# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/alationConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from .....security.credentials import apiAccessTokenAuth, basicAuth
from .. import connectionBasicType
from ..database import mysqlConnection, postgresConnection


class AlationType(Enum):
    Alation = 'Alation'


class AlationConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[AlationType] = Field(AlationType.Alation, description='Service Type')
    hostPort: AnyUrl = Field(
        ..., description='Host and port of the Alation service.', title='Host and Port'
    )
    authType: Union[basicAuth.BasicAuth, apiAccessTokenAuth.ApiAccessTokenAuth] = Field(
        ...,
        description='Types of methods used to authenticate to the alation instance',
        title='Authentication type for Alation',
    )
    connection: Optional[
        Union[
            postgresConnection.PostgresConnection,
            mysqlConnection.MysqlConnection,
            Dict[str, Any],
        ]
    ] = Field(
        None,
        description='Choose between mysql and postgres connection for alation database',
        title='Alation Database Connection',
    )
    projectName: Optional[str] = Field(
        'AlationAPI',
        description='Project name to create the refreshToken. Can be anything',
        title='Project Name',
    )
    paginationLimit: Optional[int] = Field(
        10,
        description='Pagination limit used for Alation APIs pagination',
        title='Pagination Limit',
    )
    includeUndeployedDatasources: Optional[bool] = Field(
        False,
        description='Specifies if undeployed datasources should be included while ingesting.',
        title='Include Undeployed Datasources',
    )
    includeHiddenDatasources: Optional[bool] = Field(
        False,
        description='Specifies if hidden datasources should be included while ingesting.',
        title='Include Hidden Datasources',
    )
    ingestDatasources: Optional[bool] = Field(
        True,
        description='Specifies if Datasources are to be ingested while running the ingestion job.',
        title='Ingest Datasources',
    )
    ingestUsersAndGroups: Optional[bool] = Field(
        True,
        description='Specifies if Users and Groups are to be ingested while running the ingestion job.',
        title='Ingest Users and Groups',
    )
    ingestDomains: Optional[bool] = Field(
        True,
        description='Specifies if Domains are to be ingested while running the ingestion job.',
        title='Ingest Domains',
    )
    ingestKnowledgeArticles: Optional[bool] = Field(
        True,
        description='Specifies if Knowledge Articles are to be ingested while running the ingestion job.',
        title='Ingest Knowledge Articles',
    )
    ingestDashboards: Optional[bool] = Field(
        True,
        description='Specifies if Dashboards are to be ingested while running the ingestion job.',
        title='Ingest Dashboards',
    )
    alationTagClassificationName: Optional[str] = Field(
        'alationTags',
        description='Custom OpenMetadata Classification name for alation tags.',
        title='Alation Tags Classification Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
