# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/kafkaConnectConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr


class KafkaConnectType(Enum):
    KafkaConnect = 'KafkaConnect'


class BasicAuthentication(BaseModel):
    class Config:
        extra = Extra.forbid

    username: Optional[str] = Field(
        None,
        description='KafkaConnect user to authenticate to the API.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None,
        description='KafkaConnect password to authenticate to the API.',
        title='Password',
    )


class KafkaConnectConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[KafkaConnectType] = Field(
        KafkaConnectType.KafkaConnect, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ...,
        description='KafkaConnect Service Management/UI URI.',
        title='Host And Port',
    )
    KafkaConnectConfig: Optional[BasicAuthentication] = Field(
        None,
        description='We support username/password or No Authentication',
        title='KafkaConnect Credentials Configuration',
    )
    verifySSL: Optional[bool] = Field(
        True,
        description='Boolean marking if we need to verify the SSL certs for KafkaConnect REST API. True by default.',
        title='Verify SSL',
    )
    messagingServiceName: Optional[str] = Field(
        None,
        description='Name of the Kafka Messaging Service associated with this KafkaConnect Pipeline Service. e.g. local_kafka',
        title='Kafka Service Name',
    )
