# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/nifiConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class NifiType(Enum):
    Nifi = 'Nifi'


class BasicAuthentication(BaseModel):
    class Config:
        extra = Extra.forbid

    username: Optional[str] = Field(
        None, description='Nifi user to authenticate to the API.', title='Username'
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Nifi password to authenticate to the API.', title='Password'
    )
    verifySSL: Optional[bool] = Field(
        False,
        description='Boolean marking if we need to verify the SSL certs for Nifi. False by default.',
        title='Verify SSL',
    )


class ClientCertificateAuthentication(BaseModel):
    class Config:
        extra = Extra.forbid

    certificateAuthorityPath: Optional[str] = Field(
        None,
        description='Path to the root CA certificate',
        title='Certificat Authority Path',
    )
    clientCertificatePath: Optional[str] = Field(
        None, description='Path to the client certificate', title='Client Certificat'
    )
    clientkeyPath: Optional[str] = Field(
        None, description='Path to the client key', title='Client Key'
    )


class NifiConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[NifiType] = Field(
        NifiType.Nifi, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ..., description='Pipeline Service Management/UI URI.', title='Host And Port'
    )
    nifiConfig: Union[BasicAuthentication, ClientCertificateAuthentication] = Field(
        ...,
        description='We support username/password or client certificate authentication',
        title='Nifi Credentials Configuration',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
