# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/openLineageConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class ConsumerOffsets(Enum):
    earliest = 'earliest'
    latest = 'latest'


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SSL = 'SSL'


class OpenLineageType(Enum):
    OpenLineage = 'OpenLineage'


class OpenLineageConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OpenLineageType] = Field(
        OpenLineageType.OpenLineage, description='Service Type'
    )
    brokersUrl: Optional[str] = Field(
        None,
        description='service type of the messaging source',
        title='Kafka brokers list',
    )
    topicName: Optional[str] = Field(
        None,
        description='topic from where Open lineage events will be pulled ',
        title='Topic Name',
    )
    consumerGroupName: Optional[str] = Field(
        None, description='consumer group name ', title='Consumer Group'
    )
    consumerOffsets: Optional[ConsumerOffsets] = Field(
        ConsumerOffsets.earliest,
        description='initial Kafka consumer offset',
        title='Initial consumer offsets',
    )
    poolTimeout: Optional[float] = Field(
        1.0, description='max allowed wait time', title='Single pool call timeout'
    )
    sessionTimeout: Optional[int] = Field(
        30,
        description='max allowed inactivity time',
        title='Broker inactive session timeout',
    )
    securityProtocol: Optional[SecurityProtocol] = Field(
        SecurityProtocol.PLAINTEXT,
        description='Kafka security protocol config',
        title='Kafka security protocol',
    )
    sslConfig: Optional[verifySSLConfig.SslConfig] = Field(
        None, description='SSL Configuration details.', title='SSL'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
