# generated by datamodel-codegen:
#   filename:  entity/services/ingestionPipelines/status.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field


class IngestionStatusModel(BaseModel):
    class Config:
        extra = Extra.forbid

    __root__: Any = Field(
        ..., description='Ingestion detailed status', title='IngestionStatusModel'
    )


class StackTraceError(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name of the asset with the error')
    error: str = Field(..., description='Error being handled')
    stackTrace: Optional[str] = Field(None, description='Exception stack trace')


class StepSummary(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Step name')
    records: Optional[int] = Field(
        0, description='Number of successfully processed records.'
    )
    updated_records: Optional[int] = Field(
        0, description='Number of successfully updated records.'
    )
    warnings: Optional[int] = Field(
        0, description='Number of records raising warnings.'
    )
    errors: Optional[int] = Field(0, description='Number of records with errors.')
    filtered: Optional[int] = Field(0, description='Number of filtered records.')
    failures: Optional[List[StackTraceError]] = Field(
        None, description='Sample of errors encountered in the step'
    )


class IngestionStatus(BaseModel):
    __root__: List[StepSummary] = Field(
        ...,
        description='Summary for each step of the ingestion pipeline',
        title='IngestionStatus',
    )
