# generated by datamodel-codegen:
#   filename:  entity/utils/supersetApiConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from ...security.ssl import verifySSLConfig


class ApiProvider(Enum):
    db = 'db'
    ldap = 'ldap'


class SupersetApiConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    provider: ApiProvider = Field(
        ...,
        description="Authentication provider for the Superset service. For basic user/password authentication, the default value `db` can be used. This parameter is used internally to connect to Superset's REST API.",
        title='Provider',
    )
    username: str = Field(..., description='Username for Superset.', title='Username')
    password: CustomSecretStr = Field(
        ..., description='Password for Superset.', title='Password'
    )
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
