# generated by datamodel-codegen:
#   filename:  events/api/createEventSubscription.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference
from .. import eventSubscription


class CreateEventSubscription(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Alert.'
    )
    displayName: Optional[str] = Field(None, description='Display name for this Alert.')
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Alert, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Alert.'
    )
    enabled: Optional[bool] = Field(True, description='Is the alert enabled.')
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    alertType: eventSubscription.AlertType = Field(..., description='Type of Alert')
    trigger: Optional[eventSubscription.Trigger] = None
    resources: Optional[List[str]] = Field(
        None,
        description='Defines a list of resources that triggers the Event Subscription, Eg All, User, Teams etc.',
    )
    destinations: Optional[List[eventSubscription.Destination]] = Field(
        None, description='Subscription Config.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    retries: Optional[int] = Field(
        3, description='Number of times to retry callback on failure. (Default 3).'
    )
    pollInterval: Optional[int] = Field(10, description='Poll Interval in seconds.')
    input: Optional[eventSubscription.AlertFilteringInput] = Field(
        None, description='Input for the Filters.'
    )
