# generated by datamodel-codegen:
#   filename:  events/eventFilterRule.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class InputType(Enum):
    static = 'static'
    runtime = 'runtime'
    none = 'none'


class Effect(Enum):
    include = 'include'
    exclude = 'exclude'


class PrefixCondition(Enum):
    AND = 'AND'
    OR = 'OR'


class EventFilterRule(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description='Name of this Event Filter.')
    displayName: Optional[str] = Field(None, description='Display Name of the Filter.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='FullyQualifiedName in the form `eventSubscription.eventFilterRuleName`.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Event Filter Rule.'
    )
    effect: Effect
    condition: basic.Expression = Field(
        ...,
        description='Expression in SpEL used for matching of a `Rule` based on entity, resource, and environmental attributes.',
    )
    arguments: Optional[List[str]] = Field(
        None, description='Arguments to the Condition.'
    )
    inputType: Optional[InputType] = None
    prefixCondition: Optional[PrefixCondition] = Field(
        PrefixCondition.AND,
        description='Prefix Condition to be applied to the Condition.',
    )
