# generated by datamodel-codegen:
#   filename:  metadataIngestion/pipelineServiceMetadataPipeline.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class LineageInformation(BaseModel):
    dbServiceNames: Optional[List[str]] = Field(
        None,
        description='List of Database Service Names for creation of lineage',
        title='Database Service Names List',
    )
    storageServiceNames: Optional[List[str]] = Field(
        None,
        description='List of Storage Service Names for creation of lineage',
        title='Storage Service Names List',
    )


class PipelineMetadataConfigType(Enum):
    PipelineMetadata = 'PipelineMetadata'


class PipelineServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PipelineMetadataConfigType] = Field(
        PipelineMetadataConfigType.PipelineMetadata, description='Pipeline type'
    )
    includeLineage: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching lineage from pipelines.',
        title='Include Lineage',
    )
    includeOwners: Optional[bool] = Field(
        True,
        description="Set the 'Include Owners' toggle to control whether to include owners to the ingested entity if the owner email matches with a user stored in the OM server as part of metadata ingestion. If the ingested entity already exists and has an owner, the owner will not be overwritten.",
        title='Include Owners',
    )
    pipelineFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude pipelines.', title='Pipeline Filter Pattern'
    )
    lineageInformation: Optional[LineageInformation] = Field(
        None,
        description='Details required to generate Lineage',
        title='Lineage Information',
    )
    markDeletedPipelines: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete Pipelines in OpenMetadata if the source Pipelines are deleted. Also, if the Pipeline is deleted, all the associated entities like lineage, etc., with that Pipeline will be deleted',
        title='Mark Deleted Pipeline',
    )
    includeTags: Optional[bool] = Field(
        True,
        description='Optional configuration to toggle the tags ingestion.',
        title='Include Tags',
    )
    includeUnDeployedPipelines: Optional[bool] = Field(
        True,
        description='Optional configuration to toggle whether the un-deployed pipelines should be ingested or not. If set to false, only deployed pipelines will be ingested.',
        title='Include UnDeployed Pipelines',
    )
