# generated by datamodel-codegen:
#   filename:  security/client/oidcClientConfig.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, Extra, Field


class ClientAuthenticationMethod(Enum):
    client_secret_basic = 'client_secret_basic'
    client_secret_post = 'client_secret_post'
    client_secret_jwt = 'client_secret_jwt'
    private_key_jwt = 'private_key_jwt'


class OidcClientConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = Field(None, description='IDP type (Example Google,Azure).')
    id: Optional[str] = Field(None, description='Client ID.')
    secret: Optional[str] = Field(None, description='Client Secret.')
    scope: Optional[str] = Field(
        'openid email profile', description='Oidc Request Scopes.'
    )
    discoveryUri: Optional[str] = Field(
        None, description='Discovery Uri for the Client.'
    )
    useNonce: Optional[str] = Field(True, description='Use Nonce.')
    preferredJwsAlgorithm: Optional[str] = Field(
        'RS256', description='Preferred Jws Algorithm.'
    )
    responseType: Optional[str] = Field('code', description='Auth0 Client Secret Key.')
    disablePkce: Optional[bool] = Field(True, description='Disable PKCE.')
    maxClockSkew: Optional[str] = Field(None, description='Max Clock Skew')
    clientAuthenticationMethod: Optional[ClientAuthenticationMethod] = Field(
        None, description='Client Authentication Method.'
    )
    customParams: Optional[Dict[str, Any]] = Field(None, description='Custom Params.')
    tenant: Optional[str] = Field(None, description='Tenant in case of Azure.')
    serverUrl: Optional[str] = Field(None, description='Server Url.')
    callbackUrl: Optional[str] = Field(None, description='Callback Url.')
