# generated by datamodel-codegen:
#   filename:  security/credentials/gcpCredentials.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from . import gcpExternalAccount, gcpValues


class GcpCredentialsPath(BaseModel):
    __root__: str = Field(
        ...,
        description='Pass the path of file containing the GCP credentials info',
        title='GCP Credentials Path',
    )


class GCPImpersonateServiceAccountValues(BaseModel):
    impersonateServiceAccount: Optional[str] = Field(
        None,
        description='The impersonated service account email',
        title='Target Service Account Email',
    )
    lifetime: Optional[int] = Field(
        3600,
        description='Number of seconds the delegated credential should be valid',
        title='Lifetime',
    )


class GCPCredentials(BaseModel):
    class Config:
        extra = Extra.forbid

    gcpConfig: Union[
        gcpValues.GcpCredentialsValues,
        GcpCredentialsPath,
        gcpExternalAccount.GcpExternalAccount,
    ] = Field(
        ...,
        description='We support two ways of authenticating to GCP i.e via GCP Credentials Values or GCP Credentials Path',
        title='GCP Credentials Configuration',
    )
    gcpImpersonateServiceAccount: Optional[GCPImpersonateServiceAccountValues] = Field(
        None,
        description='we enable the authenticated service account to impersonate another service account',
        title='GCP Impersonate Service Account Configuration',
    )
