# generated by datamodel-codegen:
#   filename:  type/changeEvent.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Any, Optional

from pydantic import BaseModel, Extra, Field

from . import basic, changeEventType, entityHistory


class ChangeEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier for the event.')
    eventType: changeEventType.EventType
    entityType: str = Field(
        ...,
        description='Entity type that changed. Use the schema of this entity to process the entity attribute.',
    )
    entityId: basic.Uuid = Field(
        ..., description='Identifier of entity that was modified by the operation.'
    )
    entityFullyQualifiedName: Optional[str] = Field(
        None,
        description='Fully Qualified Name of entity that was modified by the operation.',
    )
    previousVersion: Optional[entityHistory.EntityVersion] = Field(
        None,
        description='Version of the entity before this change. Note that not all changes result in entity version change. When entity version is not changed, `previousVersion` is same as `currentVersion`.',
    )
    currentVersion: Optional[entityHistory.EntityVersion] = Field(
        None,
        description='Current version of the entity after this change. Note that not all changes result in entity version change. When entity version is not changed, `previousVersion` is same as `currentVersion`.',
    )
    userName: Optional[str] = Field(
        None, description='Name of the user whose activity resulted in the change.'
    )
    timestamp: basic.Timestamp = Field(
        ...,
        description='Timestamp when the change was made in Unix epoch time milliseconds.',
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None,
        description='For `eventType` `entityUpdated` this field captures details about what fields were added/updated/deleted. For `eventType` `entityCreated` or `entityDeleted` this field is null.',
    )
    entity: Optional[Any] = Field(
        None,
        description='For `eventType` `entityCreated`, this field captures JSON coded string of the entity using the schema corresponding to `entityType`.',
    )
