# generated by datamodel-codegen:
#   filename:  type/entityHierarchy.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from . import basic


class EntityHierarchy(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of an entity hierarchy instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Preferred name for the entity hierarchy.'
    )
    displayName: Optional[str] = Field(
        None, description='Display name that identifies this hierarchy.'
    )
    description: basic.Markdown = Field(
        ..., description='Description of the entity hierarchy.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='A unique name that identifies an entity within the hierarchy. It captures name hierarchy in the form of `rootEntity.childEntity`.',
    )
    children: Optional[List[EntityHierarchy]] = Field(
        None, description='Other entities that are children of this entity.'
    )


EntityHierarchy.update_forward_refs()
