# coding: utf-8

"""
    CredentialIssuanceService

    Affinidi Credential Issuance Service Structure

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr

class IssuanceConfigDtoCredentialSupportedInner(BaseModel):
    """
    IssuanceConfigDtoCredentialSupportedInner
    """
    credential_type_id: StrictStr = Field(..., alias="credentialTypeId", description="It is a String that identifies a Credential that is being requested to be issued.")
    json_schema_url: StrictStr = Field(..., alias="jsonSchemaUrl", description="credential jsonLdContextUrl")
    json_ld_context_url: StrictStr = Field(..., alias="jsonLdContextUrl", description="credential jsonSchemaUrl")
    __properties = ["credentialTypeId", "jsonSchemaUrl", "jsonLdContextUrl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssuanceConfigDtoCredentialSupportedInner:
        """Create an instance of IssuanceConfigDtoCredentialSupportedInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssuanceConfigDtoCredentialSupportedInner:
        """Create an instance of IssuanceConfigDtoCredentialSupportedInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IssuanceConfigDtoCredentialSupportedInner.parse_obj(obj)

        _obj = IssuanceConfigDtoCredentialSupportedInner.parse_obj({
            "credential_type_id": obj.get("credentialTypeId"),
            "json_schema_url": obj.get("jsonSchemaUrl"),
            "json_ld_context_url": obj.get("jsonLdContextUrl")
        })
        return _obj


