# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class StartIssuanceResponse(BaseModel):
    """
    StartIssuanceResponse
    """
    credential_offer_uri: StrictStr = Field(default=..., alias="credentialOfferUri", description="URL where wallet can view offer details")
    tx_code: Optional[StrictStr] = Field(default=None, alias="txCode", description="One time transaction code generated by CIS")
    issuance_id: StrictStr = Field(default=..., alias="issuanceId", description="Website's internal identifier. Website may use to get info about the status of issuance flow. If it is not provided, CIS will generate one.")
    expires_in: Union[StrictFloat, StrictInt] = Field(default=..., alias="expiresIn", description="Expire time in seconds")
    __properties = ["credentialOfferUri", "txCode", "issuanceId", "expiresIn"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StartIssuanceResponse:
        """Create an instance of StartIssuanceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartIssuanceResponse:
        """Create an instance of StartIssuanceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StartIssuanceResponse.parse_obj(obj)

        _obj = StartIssuanceResponse.parse_obj({
            "credential_offer_uri": obj.get("credentialOfferUri"),
            "tx_code": obj.get("txCode"),
            "issuance_id": obj.get("issuanceId"),
            "expires_in": obj.get("expiresIn")
        })
        return _obj


