# pyMatOps.pyi
from typing import List, Tuple, overload, Union

class Matrix:
    @overload
    def __init__(self, container: List[List[float]]) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int, initialValue: float) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...

    def shape(self) -> Tuple[int, int]: ...
    def transpose(self) -> "Matrix": ...
    def determinant(self) -> float: ...
    def inverse(self) -> "Matrix": ...

    @overload
    def insertRow(self, row: List[float], idx: int) -> "Matrix": ...
    @overload
    def insertRow(self, rowVal: float, idx: int) -> "Matrix": ...
    def insertRow(self, *args, **kwargs) -> "Matrix": ...

    @overload
    def insertCol(self, col: List[float], idx: int) -> "Matrix": ...
    @overload
    def insertCol(self, colVal: float, idx: int) -> "Matrix": ...
    def insertCol(self, *args, **kwargs) -> "Matrix": ...

    def hStack(self, other: "Matrix") -> "Matrix": ...
    def vStack(self, other: "Matrix") -> "Matrix": ...
    def extractMatrix(self, rowSlice: Tuple[int, int], colSlice: Tuple[int, int]) -> "Matrix": ...

    def sum(self) -> float: ...
    def mean(self) -> float: ...

    def __getitem__(self, index: Tuple[int, int]) -> float: ...
    def __setitem__(self, index: Tuple[int, int], value: float) -> None: ...

    def __add__(self, other: Union["Matrix", float]) -> "Matrix": ...
    def __radd__(self, other: float) -> "Matrix": ...
    def __sub__(self, other: Union["Matrix", float]) -> "Matrix": ...
    def __rsub__(self, other: float) -> "Matrix": ...
    def __mul__(self, other: Union["Matrix", float]) -> "Matrix": ...
    def __rmul__(self, other: float) -> "Matrix": ...
    def __truediv__(self, other: float) -> "Matrix": ...

    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...

    def __eq__(self, other: object) -> bool: ...