"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PricingCategory:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PricingCategoryEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _PricingCategory.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRICING_CATEGORY_UNSPECIFIED: _PricingCategory.ValueType  # 0
    """Default/unknown category"""
    PRICING_CATEGORY_TEXT: _PricingCategory.ValueType  # 1
    """Text generation models (GPT-4, Claude, etc.)
    Example: GPT-4o, GPT-4o-mini for chat/completion
    """
    PRICING_CATEGORY_IMAGE: _PricingCategory.ValueType  # 2
    """Image understanding/analysis models
    Example: GPT-4-vision analyzing uploaded images
    """
    PRICING_CATEGORY_AUDIO: _PricingCategory.ValueType  # 3
    """Audio models for speech-to-text and text-to-speech
    Example: Whisper for transcription, TTS models for voice synthesis
    """
    PRICING_CATEGORY_EMBEDDING: _PricingCategory.ValueType  # 4
    """Embedding/vector models
    Example: text-embedding-3-large for semantic search
    """
    PRICING_CATEGORY_FINE_TUNING: _PricingCategory.ValueType  # 5
    """Fine-tuning costs for training custom models
    Example: Training GPT-4o-mini-2024-07-18 on custom data
    """
    PRICING_CATEGORY_TOOL: _PricingCategory.ValueType  # 6
    """Built-in or add-on tools and capabilities
    Example: Web Search ($2/1k calls), Code Interpreter ($0.03/container)
    """
    PRICING_CATEGORY_REALTIME: _PricingCategory.ValueType  # 7
    """Realtime/streaming API pricing
    Example: WebSocket-based continuous interaction models
    """
    PRICING_CATEGORY_MODERATION: _PricingCategory.ValueType  # 8
    """Content moderation models
    Example: OpenAI moderation endpoint for content filtering
    """
    PRICING_CATEGORY_LEGACY: _PricingCategory.ValueType  # 9
    """Deprecated/legacy models with special pricing
    Example: GPT-3.5-turbo-0301 (older version)
    """

class PricingCategory(_PricingCategory, metaclass=_PricingCategoryEnumTypeWrapper):
    """PricingCategory defines the type of AI capability being priced."""

PRICING_CATEGORY_UNSPECIFIED: PricingCategory.ValueType  # 0
"""Default/unknown category"""
PRICING_CATEGORY_TEXT: PricingCategory.ValueType  # 1
"""Text generation models (GPT-4, Claude, etc.)
Example: GPT-4o, GPT-4o-mini for chat/completion
"""
PRICING_CATEGORY_IMAGE: PricingCategory.ValueType  # 2
"""Image understanding/analysis models
Example: GPT-4-vision analyzing uploaded images
"""
PRICING_CATEGORY_AUDIO: PricingCategory.ValueType  # 3
"""Audio models for speech-to-text and text-to-speech
Example: Whisper for transcription, TTS models for voice synthesis
"""
PRICING_CATEGORY_EMBEDDING: PricingCategory.ValueType  # 4
"""Embedding/vector models
Example: text-embedding-3-large for semantic search
"""
PRICING_CATEGORY_FINE_TUNING: PricingCategory.ValueType  # 5
"""Fine-tuning costs for training custom models
Example: Training GPT-4o-mini-2024-07-18 on custom data
"""
PRICING_CATEGORY_TOOL: PricingCategory.ValueType  # 6
"""Built-in or add-on tools and capabilities
Example: Web Search ($2/1k calls), Code Interpreter ($0.03/container)
"""
PRICING_CATEGORY_REALTIME: PricingCategory.ValueType  # 7
"""Realtime/streaming API pricing
Example: WebSocket-based continuous interaction models
"""
PRICING_CATEGORY_MODERATION: PricingCategory.ValueType  # 8
"""Content moderation models
Example: OpenAI moderation endpoint for content filtering
"""
PRICING_CATEGORY_LEGACY: PricingCategory.ValueType  # 9
"""Deprecated/legacy models with special pricing
Example: GPT-3.5-turbo-0301 (older version)
"""
global___PricingCategory = PricingCategory

class _PricingTier:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PricingTierEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PricingTier.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRICING_TIER_UNSPECIFIED: _PricingTier.ValueType  # 0
    """Default/unknown tier"""
    PRICING_TIER_FREE: _PricingTier.ValueType  # 1
    """Free tier with usage limits
    Example: Free API credits for new users
    """
    PRICING_TIER_BATCH: _PricingTier.ValueType  # 2
    """Batch processing with 50% discount, 24-hour turnaround
    Example: GPT-4o batch API at $1.25/1M input tokens (vs $2.50 standard)
    """
    PRICING_TIER_FLEX: _PricingTier.ValueType  # 3
    """Flexible/on-demand tier (between batch and standard)
    Example: Variable pricing based on system load
    """
    PRICING_TIER_STANDARD: _PricingTier.ValueType  # 4
    """Standard/regular pricing tier
    Example: GPT-4o at $2.50/1M input tokens for real-time API
    """
    PRICING_TIER_PRIORITY: _PricingTier.ValueType  # 5
    """Priority access with higher costs but guaranteed availability
    Example: Reserved capacity with SLA guarantees
    """
    PRICING_TIER_ENTERPRISE: _PricingTier.ValueType  # 6
    """Enterprise/custom pricing with negotiated rates
    Example: Volume discounts for large organizations
    """

class PricingTier(_PricingTier, metaclass=_PricingTierEnumTypeWrapper):
    """PricingTier represents different service levels with varying costs and SLAs."""

PRICING_TIER_UNSPECIFIED: PricingTier.ValueType  # 0
"""Default/unknown tier"""
PRICING_TIER_FREE: PricingTier.ValueType  # 1
"""Free tier with usage limits
Example: Free API credits for new users
"""
PRICING_TIER_BATCH: PricingTier.ValueType  # 2
"""Batch processing with 50% discount, 24-hour turnaround
Example: GPT-4o batch API at $1.25/1M input tokens (vs $2.50 standard)
"""
PRICING_TIER_FLEX: PricingTier.ValueType  # 3
"""Flexible/on-demand tier (between batch and standard)
Example: Variable pricing based on system load
"""
PRICING_TIER_STANDARD: PricingTier.ValueType  # 4
"""Standard/regular pricing tier
Example: GPT-4o at $2.50/1M input tokens for real-time API
"""
PRICING_TIER_PRIORITY: PricingTier.ValueType  # 5
"""Priority access with higher costs but guaranteed availability
Example: Reserved capacity with SLA guarantees
"""
PRICING_TIER_ENTERPRISE: PricingTier.ValueType  # 6
"""Enterprise/custom pricing with negotiated rates
Example: Volume discounts for large organizations
"""
global___PricingTier = PricingTier

class _Operation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OperationEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Operation.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPERATION_UNSPECIFIED: _Operation.ValueType  # 0
    """Default/unknown operation"""
    OPERATION_INPUT: _Operation.ValueType  # 1
    """Input/prompt tokens sent to the model
    Example: User message in chat, $2.50/1M tokens for GPT-4o
    """
    OPERATION_OUTPUT: _Operation.ValueType  # 2
    """Output/completion tokens generated by the model
    Example: Model response, $10.00/1M tokens for GPT-4o
    """
    OPERATION_CACHED_INPUT: _Operation.ValueType  # 3
    """Cached input tokens (discounted rate for repeated context)
    Example: $1.25/1M tokens for GPT-4o cached prompt (50% discount)
    """
    OPERATION_CACHE_READ: _Operation.ValueType  # 4
    """Reading from cache (if priced separately from cached input)
    Example: Anthropic Claude cache read operations
    """
    OPERATION_CACHE_WRITE: _Operation.ValueType  # 5
    """Writing to cache (creating cached context)
    Example: Anthropic Claude cache creation fee
    """
    OPERATION_TRAINING: _Operation.ValueType  # 6
    """Fine-tuning training cost (per token or per hour)
    Example: $25.00/1M tokens or $3.00/hour for GPT-4o-mini training
    """
    OPERATION_STORAGE: _Operation.ValueType  # 7
    """General storage costs
    Example: Vector database storage for embeddings
    """
    OPERATION_CONTEXT_CACHE_STORAGE: _Operation.ValueType  # 8
    """Context cache storage charged per time unit
    Example: $0.10/GB/hour for maintaining cached contexts
    """
    OPERATION_PER_CALL: _Operation.ValueType  # 9
    """Fixed price per API call regardless of tokens
    Example: $0.00255/call for file search tool
    """
    OPERATION_PER_CONTAINER: _Operation.ValueType  # 10
    """Per container/session pricing for isolated environments
    Example: $0.03/container for Code Interpreter execution
    """

class Operation(_Operation, metaclass=_OperationEnumTypeWrapper):
    """Operation defines the specific type of usage being priced."""

OPERATION_UNSPECIFIED: Operation.ValueType  # 0
"""Default/unknown operation"""
OPERATION_INPUT: Operation.ValueType  # 1
"""Input/prompt tokens sent to the model
Example: User message in chat, $2.50/1M tokens for GPT-4o
"""
OPERATION_OUTPUT: Operation.ValueType  # 2
"""Output/completion tokens generated by the model
Example: Model response, $10.00/1M tokens for GPT-4o
"""
OPERATION_CACHED_INPUT: Operation.ValueType  # 3
"""Cached input tokens (discounted rate for repeated context)
Example: $1.25/1M tokens for GPT-4o cached prompt (50% discount)
"""
OPERATION_CACHE_READ: Operation.ValueType  # 4
"""Reading from cache (if priced separately from cached input)
Example: Anthropic Claude cache read operations
"""
OPERATION_CACHE_WRITE: Operation.ValueType  # 5
"""Writing to cache (creating cached context)
Example: Anthropic Claude cache creation fee
"""
OPERATION_TRAINING: Operation.ValueType  # 6
"""Fine-tuning training cost (per token or per hour)
Example: $25.00/1M tokens or $3.00/hour for GPT-4o-mini training
"""
OPERATION_STORAGE: Operation.ValueType  # 7
"""General storage costs
Example: Vector database storage for embeddings
"""
OPERATION_CONTEXT_CACHE_STORAGE: Operation.ValueType  # 8
"""Context cache storage charged per time unit
Example: $0.10/GB/hour for maintaining cached contexts
"""
OPERATION_PER_CALL: Operation.ValueType  # 9
"""Fixed price per API call regardless of tokens
Example: $0.00255/call for file search tool
"""
OPERATION_PER_CONTAINER: Operation.ValueType  # 10
"""Per container/session pricing for isolated environments
Example: $0.03/container for Code Interpreter execution
"""
global___Operation = Operation

class _PriceUnit:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PriceUnitEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PriceUnit.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRICE_UNIT_UNSPECIFIED: _PriceUnit.ValueType  # 0
    """Default/unknown unit"""
    PRICE_UNIT_PER_1M_TOKENS: _PriceUnit.ValueType  # 1
    """Price per million tokens (most common for LLMs)
    Example: $2.50 per 1M input tokens
    """
    PRICE_UNIT_PER_IMAGE: _PriceUnit.ValueType  # 2
    """Price per generated image
    Example: DALL-E 3 at $0.040 per 1024x1024 image
    """
    PRICE_UNIT_PER_MINUTE: _PriceUnit.ValueType  # 3
    """Price per minute of processing
    Example: Whisper at $0.006 per minute of audio
    """
    PRICE_UNIT_PER_1M_CHARACTERS: _PriceUnit.ValueType  # 4
    """Price per million characters (for text not tokenized)
    Example: Some translation APIs charge per character
    """
    PRICE_UNIT_PER_CALL: _PriceUnit.ValueType  # 5
    """Fixed price per API call
    Example: Moderation at $0.001 per call
    """
    PRICE_UNIT_PER_GB_DAY: _PriceUnit.ValueType  # 6
    """Storage price per GB per day
    Example: File search storage at $0.20/GB/day
    """
    PRICE_UNIT_PER_HOUR: _PriceUnit.ValueType  # 7
    """Price per hour (training or runtime)
    Example: Fine-tuning at $3.00/hour for small models
    """
    PRICE_UNIT_PER_1K_CALLS: _PriceUnit.ValueType  # 8
    """Price per thousand API calls
    Example: Web search at $2.00 per 1k searches
    """

class PriceUnit(_PriceUnit, metaclass=_PriceUnitEnumTypeWrapper):
    """PriceUnit specifies how the price is measured/charged."""

PRICE_UNIT_UNSPECIFIED: PriceUnit.ValueType  # 0
"""Default/unknown unit"""
PRICE_UNIT_PER_1M_TOKENS: PriceUnit.ValueType  # 1
"""Price per million tokens (most common for LLMs)
Example: $2.50 per 1M input tokens
"""
PRICE_UNIT_PER_IMAGE: PriceUnit.ValueType  # 2
"""Price per generated image
Example: DALL-E 3 at $0.040 per 1024x1024 image
"""
PRICE_UNIT_PER_MINUTE: PriceUnit.ValueType  # 3
"""Price per minute of processing
Example: Whisper at $0.006 per minute of audio
"""
PRICE_UNIT_PER_1M_CHARACTERS: PriceUnit.ValueType  # 4
"""Price per million characters (for text not tokenized)
Example: Some translation APIs charge per character
"""
PRICE_UNIT_PER_CALL: PriceUnit.ValueType  # 5
"""Fixed price per API call
Example: Moderation at $0.001 per call
"""
PRICE_UNIT_PER_GB_DAY: PriceUnit.ValueType  # 6
"""Storage price per GB per day
Example: File search storage at $0.20/GB/day
"""
PRICE_UNIT_PER_HOUR: PriceUnit.ValueType  # 7
"""Price per hour (training or runtime)
Example: Fine-tuning at $3.00/hour for small models
"""
PRICE_UNIT_PER_1K_CALLS: PriceUnit.ValueType  # 8
"""Price per thousand API calls
Example: Web search at $2.00 per 1k searches
"""
global___PriceUnit = PriceUnit

@typing.final
class Pricing(google.protobuf.message.Message):
    """Pricing represents the complete pricing structure for a model or service.
    A single model may have multiple pricing items for different operations,
    tiers, and use cases.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    CURRENCY_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    currency: builtins.str
    """Currency code for all prices in this message.
    Examples: "USD", "EUR", "GBP"
    """
    @property
    def items(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PricingItem
    ]:
        """List of all pricing entries for this model.
        Each item represents a specific price point for a particular
        operation/tier combination.
        Example: One item for standard input tokens, another for batch input tokens
        """

    @property
    def metadata(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional metadata as key-value pairs.
        Common keys:
        - "footnote": Additional pricing notes (e.g., "[1] Limited availability")
        - "estimated_cost": Estimated costs for transcription models
        - "source_url": URL where pricing was sourced from
        - "last_updated": ISO 8601 timestamp of last update
        """

    def __init__(
        self,
        *,
        currency: builtins.str = ...,
        items: collections.abc.Iterable[global___PricingItem] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "currency", b"currency", "items", b"items", "metadata", b"metadata"
        ],
    ) -> None: ...

global___Pricing = Pricing

@typing.final
class TokenBand(google.protobuf.message.Message):
    """TokenBand represents tiered pricing based on token count thresholds.
    Some models have different rates based on cumulative token usage.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    MAX_PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    min_prompt_tokens: builtins.int
    """Minimum number of prompt tokens for this pricing tier (inclusive).
    Example: 0 for the first tier, 200001 for the "over 200k" tier
    Set to 0 if not applicable or for the lowest tier
    """
    max_prompt_tokens: builtins.int
    """Maximum number of prompt tokens for this pricing tier (inclusive).
    Example: 200000 for "up to 200k tokens" tier
    Set to 0 if unlimited or not applicable
    """
    def __init__(
        self,
        *,
        min_prompt_tokens: builtins.int = ...,
        max_prompt_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_prompt_tokens",
            b"max_prompt_tokens",
            "min_prompt_tokens",
            b"min_prompt_tokens",
        ],
    ) -> None: ...

global___TokenBand = TokenBand

@typing.final
class PricingItem(google.protobuf.message.Message):
    """PricingItem represents a specific price point for a model/service.
    Each item captures one pricing scenario with all relevant qualifiers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_FIELD_NUMBER: builtins.int
    TIER_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    QUALITY_FIELD_NUMBER: builtins.int
    RESOLUTION_FIELD_NUMBER: builtins.int
    TOKEN_BAND_FIELD_NUMBER: builtins.int
    INCLUDES_THINKING_TOKENS_FIELD_NUMBER: builtins.int
    TOOL_NAME_FIELD_NUMBER: builtins.int
    TOKEN_TYPE_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    category: global___PricingCategory.ValueType
    """The type of AI capability this price applies to.
    Example: PRICING_CATEGORY_TEXT for GPT-4o chat completion
    """
    tier: global___PricingTier.ValueType
    """Service tier affecting price and SLA.
    Example: PRICING_TIER_BATCH for 50% discounted async processing
    """
    operation: global___Operation.ValueType
    """The specific operation being charged for.
    Example: OPERATION_INPUT for prompt tokens, OPERATION_OUTPUT for completions
    """
    price: builtins.float
    """The numeric cost amount.
    Example: 2.50 for "$2.50 per 1M tokens"
    """
    unit: global___PriceUnit.ValueType
    """The unit that the price applies to.
    Example: PRICE_UNIT_PER_1M_TOKENS for token-based pricing
    """
    quality: builtins.str
    """Optional qualifiers to disambiguate pricing variants:

    Quality level for image generation.
    Examples: "standard", "hd" for DALL-E, "low", "medium", "high" for others
    """
    resolution: builtins.str
    """Image resolution for image generation pricing.
    Examples: "1024x1024", "1792x1024", "1024x1792"
    """
    includes_thinking_tokens: builtins.bool
    """Whether output pricing includes hidden reasoning tokens.
    Example: true for o1-preview which charges for internal thinking
    """
    tool_name: builtins.str
    """Name of the tool for PRICING_CATEGORY_TOOL items.
    Examples: "Web Search", "File Search", "Code Interpreter"
    """
    token_type: builtins.str
    """Token type for multi-modal pricing.
    Examples: "text" vs "audio" for Whisper transcription models
    """
    notes: builtins.str
    """Additional human-readable notes about this pricing.
    Example: "Discounted pricing with data sharing enabled"
    """
    @property
    def token_band(self) -> global___TokenBand:
        """Token count thresholds for tiered pricing.
        Example: Different rates for prompts over 200k tokens
        """

    def __init__(
        self,
        *,
        category: global___PricingCategory.ValueType = ...,
        tier: global___PricingTier.ValueType = ...,
        operation: global___Operation.ValueType = ...,
        price: builtins.float = ...,
        unit: global___PriceUnit.ValueType = ...,
        quality: builtins.str = ...,
        resolution: builtins.str = ...,
        token_band: global___TokenBand | None = ...,
        includes_thinking_tokens: builtins.bool = ...,
        tool_name: builtins.str = ...,
        token_type: builtins.str = ...,
        notes: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["token_band", b"token_band"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "category",
            b"category",
            "includes_thinking_tokens",
            b"includes_thinking_tokens",
            "notes",
            b"notes",
            "operation",
            b"operation",
            "price",
            b"price",
            "quality",
            b"quality",
            "resolution",
            b"resolution",
            "tier",
            b"tier",
            "token_band",
            b"token_band",
            "token_type",
            b"token_type",
            "tool_name",
            b"tool_name",
            "unit",
            b"unit",
        ],
    ) -> None: ...

global___PricingItem = PricingItem
