"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import weaveapi.llmx.v1.model_pb2
import weaveapi.llmx.v1.provider_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ListProvidersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ACTIVE_ONLY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    page_token: builtins.str
    active_only: builtins.bool
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        active_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_only",
            b"active_only",
            "page_size",
            b"page_size",
            "page_token",
            b"page_token",
        ],
    ) -> None: ...

global___ListProvidersRequest = ListProvidersRequest

@typing.final
class ListProvidersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    total_count: builtins.int
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.llmx.v1.provider_pb2.Provider
    ]: ...
    def __init__(
        self,
        *,
        providers: collections.abc.Iterable[weaveapi.llmx.v1.provider_pb2.Provider]
        | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "next_page_token",
            b"next_page_token",
            "providers",
            b"providers",
            "total_count",
            b"total_count",
        ],
    ) -> None: ...

global___ListProvidersResponse = ListProvidersResponse

@typing.final
class GetProviderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SLUG_FIELD_NUMBER: builtins.int
    slug: builtins.str
    """e.g., "openai" """
    def __init__(
        self,
        *,
        slug: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["slug", b"slug"]) -> None: ...

global___GetProviderRequest = GetProviderRequest

@typing.final
class GetProviderResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    @property
    def provider(self) -> weaveapi.llmx.v1.provider_pb2.Provider: ...
    def __init__(
        self,
        *,
        provider: weaveapi.llmx.v1.provider_pb2.Provider | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["provider", b"provider"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["provider", b"provider"]
    ) -> None: ...

global___GetProviderResponse = GetProviderResponse

@typing.final
class ListModelsRequest(google.protobuf.message.Message):
    """ListModelsRequest defines filters and pagination for listing models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PROVIDER_FIELD_NUMBER: builtins.int
    MODEL_TYPE_FIELD_NUMBER: builtins.int
    ACTIVE_ONLY_FIELD_NUMBER: builtins.int
    VISION_ONLY_FIELD_NUMBER: builtins.int
    TOOL_CALLS_ONLY_FIELD_NUMBER: builtins.int
    REASONING_ONLY_FIELD_NUMBER: builtins.int
    OPEN_SOURCE_ONLY_FIELD_NUMBER: builtins.int
    MAX_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    MIN_CONTEXT_WINDOW_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    DESCENDING_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Maximum number of models to return (1-100).
    Example: 20 for paginated results
    """
    page_token: builtins.str
    """Token for fetching next page of results.
    Example: "eyJvZmZzZXQiOjIwfQ==" from previous response
    """
    provider: builtins.str
    """=== Provider and Type Filters ===

    Filter by provider slug.
    Example: "openai" to only show OpenAI models
    """
    model_type: builtins.str
    """Filter by model type.
    Examples: "chat", "embedding", "image", "audio"
    """
    active_only: builtins.bool
    """Only show currently available models.
    Example: true to exclude deprecated models
    """
    vision_only: builtins.bool
    """=== Capability Filters (models must have these features) ===

    Only models with vision/image understanding.
    Example: true for GPT-4V, Claude-3 Vision
    """
    tool_calls_only: builtins.bool
    """Only models supporting function/tool calling.
    Example: true for GPT-4, Claude-3
    """
    reasoning_only: builtins.bool
    """Only models with advanced reasoning capabilities.
    Example: true for o1-preview, o1-mini
    """
    open_source_only: builtins.bool
    """Only open-source models with public weights.
    Example: true for LLaMA, Mistral, false for GPT-4
    """
    max_input_price: builtins.float
    """=== Price Filters (per 1M tokens) ===

    Maximum acceptable input token price.
    Example: 5.0 for models under $5/1M input tokens
    """
    max_output_price: builtins.float
    """Maximum acceptable output token price.
    Example: 15.0 for models under $15/1M output tokens
    """
    min_context_window: builtins.int
    """=== Token Filters ===

    Minimum required context window size.
    Example: 32000 for models with 32k+ context
    """
    order_by: builtins.str
    """=== Sorting Options ===

    Field to sort results by.
    Options: "name", "release_date", "input_price", "context_window"
    Example: "release_date" for newest models first
    """
    descending: builtins.bool
    """Sort in descending order.
    Example: true for newest/highest first, false for oldest/lowest
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        provider: builtins.str = ...,
        model_type: builtins.str = ...,
        active_only: builtins.bool = ...,
        vision_only: builtins.bool = ...,
        tool_calls_only: builtins.bool = ...,
        reasoning_only: builtins.bool = ...,
        open_source_only: builtins.bool = ...,
        max_input_price: builtins.float = ...,
        max_output_price: builtins.float = ...,
        min_context_window: builtins.int = ...,
        order_by: builtins.str = ...,
        descending: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_only",
            b"active_only",
            "descending",
            b"descending",
            "max_input_price",
            b"max_input_price",
            "max_output_price",
            b"max_output_price",
            "min_context_window",
            b"min_context_window",
            "model_type",
            b"model_type",
            "open_source_only",
            b"open_source_only",
            "order_by",
            b"order_by",
            "page_size",
            b"page_size",
            "page_token",
            b"page_token",
            "provider",
            b"provider",
            "reasoning_only",
            b"reasoning_only",
            "tool_calls_only",
            b"tool_calls_only",
            "vision_only",
            b"vision_only",
        ],
    ) -> None: ...

global___ListModelsRequest = ListModelsRequest

@typing.final
class ListModelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    total_count: builtins.int
    @property
    def models(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.llmx.v1.model_pb2.Model
    ]: ...
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[weaveapi.llmx.v1.model_pb2.Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "models",
            b"models",
            "next_page_token",
            b"next_page_token",
            "total_count",
            b"total_count",
        ],
    ) -> None: ...

global___ListModelsResponse = ListModelsResponse

@typing.final
class GetModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """e.g., "openai" """
    model_id: builtins.str
    """e.g., "gpt-4o" """
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["model_id", b"model_id", "provider", b"provider"],
    ) -> None: ...

global___GetModelRequest = GetModelRequest

@typing.final
class GetModelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> weaveapi.llmx.v1.model_pb2.Model: ...
    def __init__(
        self,
        *,
        model: weaveapi.llmx.v1.model_pb2.Model | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["model", b"model"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["model", b"model"]) -> None: ...

global___GetModelResponse = GetModelResponse

@typing.final
class SearchModelsRequest(google.protobuf.message.Message):
    """SearchModelsRequest enables advanced model search with multiple filter criteria."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_FIELD_NUMBER: builtins.int
    PROVIDERS_FIELD_NUMBER: builtins.int
    MODEL_TYPES_FIELD_NUMBER: builtins.int
    ARCHITECTURES_FIELD_NUMBER: builtins.int
    REQUIRED_CAPABILITIES_FIELD_NUMBER: builtins.int
    REQUIRED_INPUT_MODALITIES_FIELD_NUMBER: builtins.int
    REQUIRED_OUTPUT_MODALITIES_FIELD_NUMBER: builtins.int
    PRICE_RANGE_FIELD_NUMBER: builtins.int
    TOKEN_RANGE_FIELD_NUMBER: builtins.int
    PERFORMANCE_RANGE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    DESCENDING_FIELD_NUMBER: builtins.int
    query: builtins.str
    """Full-text search across model names and descriptions.
    Example: "code generation" to find coding-focused models
    """
    page_size: builtins.int
    """=== Pagination ===

    Results per page (1-100).
    Example: 25
    """
    page_token: builtins.str
    """Continuation token from previous response."""
    order_by: builtins.str
    """=== Sorting ===

    Sort field name.
    Options: "relevance", "name", "release_date", "price", "performance"
    """
    descending: builtins.bool
    """Sort direction.
    Example: true for descending (highest/newest first)
    """
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """=== Advanced Filters (ANY match) ===

        Filter by multiple providers.
        Example: ["openai", "anthropic"] for models from either provider
        """

    @property
    def model_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Filter by multiple model types.
        Example: ["chat", "instruct"] for conversational models
        """

    @property
    def architectures(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Filter by architecture families.
        Example: ["GPT", "LLaMA", "Mistral"] for specific architectures
        """

    @property
    def required_capabilities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """=== Capability Requirements (ALL must match) ===

        Required capabilities (model must have all).
        Example: ["function_calling", "vision"] for multi-modal tool-use models
        """

    @property
    def required_input_modalities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Required input modalities (model must support all).
        Example: ["text", "image"] for vision-language models
        """

    @property
    def required_output_modalities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Required output modalities (model must support all).
        Example: ["text", "code"] for code generation models
        """

    @property
    def price_range(self) -> global___PriceRange:
        """=== Numeric Range Filters ===

        Price range constraints per 1M tokens.
        """

    @property
    def token_range(self) -> global___TokenRange:
        """Token limit constraints."""

    @property
    def performance_range(self) -> global___PerformanceRange:
        """Minimum performance scores required."""

    def __init__(
        self,
        *,
        query: builtins.str = ...,
        providers: collections.abc.Iterable[builtins.str] | None = ...,
        model_types: collections.abc.Iterable[builtins.str] | None = ...,
        architectures: collections.abc.Iterable[builtins.str] | None = ...,
        required_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        required_input_modalities: collections.abc.Iterable[builtins.str] | None = ...,
        required_output_modalities: collections.abc.Iterable[builtins.str] | None = ...,
        price_range: global___PriceRange | None = ...,
        token_range: global___TokenRange | None = ...,
        performance_range: global___PerformanceRange | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        descending: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "performance_range",
            b"performance_range",
            "price_range",
            b"price_range",
            "token_range",
            b"token_range",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "architectures",
            b"architectures",
            "descending",
            b"descending",
            "model_types",
            b"model_types",
            "order_by",
            b"order_by",
            "page_size",
            b"page_size",
            "page_token",
            b"page_token",
            "performance_range",
            b"performance_range",
            "price_range",
            b"price_range",
            "providers",
            b"providers",
            "query",
            b"query",
            "required_capabilities",
            b"required_capabilities",
            "required_input_modalities",
            b"required_input_modalities",
            "required_output_modalities",
            b"required_output_modalities",
            "token_range",
            b"token_range",
        ],
    ) -> None: ...

global___SearchModelsRequest = SearchModelsRequest

@typing.final
class PriceRange(google.protobuf.message.Message):
    """PriceRange defines min/max price constraints for filtering models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MAX_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MIN_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    min_input_price: builtins.float
    """Minimum input token price per 1M tokens.
    Example: 0.5 for at least $0.50/1M input tokens
    """
    max_input_price: builtins.float
    """Maximum input token price per 1M tokens.
    Example: 10.0 for at most $10/1M input tokens
    """
    min_output_price: builtins.float
    """Minimum output token price per 1M tokens.
    Example: 1.0 for at least $1/1M output tokens
    """
    max_output_price: builtins.float
    """Maximum output token price per 1M tokens.
    Example: 30.0 for at most $30/1M output tokens
    """
    def __init__(
        self,
        *,
        min_input_price: builtins.float = ...,
        max_input_price: builtins.float = ...,
        min_output_price: builtins.float = ...,
        max_output_price: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_input_price",
            b"max_input_price",
            "max_output_price",
            b"max_output_price",
            "min_input_price",
            b"min_input_price",
            "min_output_price",
            b"min_output_price",
        ],
    ) -> None: ...

global___PriceRange = PriceRange

@typing.final
class TokenRange(google.protobuf.message.Message):
    """TokenRange defines min/max token constraints for filtering models."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_CONTEXT_WINDOW_FIELD_NUMBER: builtins.int
    MAX_CONTEXT_WINDOW_FIELD_NUMBER: builtins.int
    MIN_OUTPUT_TOKENS_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_TOKENS_FIELD_NUMBER: builtins.int
    min_context_window: builtins.int
    """Minimum context window size required.
    Example: 8192 for at least 8k context
    """
    max_context_window: builtins.int
    """Maximum context window size allowed.
    Example: 128000 for at most 128k context
    """
    min_output_tokens: builtins.int
    """Minimum output token limit required.
    Example: 2048 for at least 2k output tokens
    """
    max_output_tokens: builtins.int
    """Maximum output token limit allowed.
    Example: 16384 for at most 16k output tokens
    """
    def __init__(
        self,
        *,
        min_context_window: builtins.int = ...,
        max_context_window: builtins.int = ...,
        min_output_tokens: builtins.int = ...,
        max_output_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_context_window",
            b"max_context_window",
            "max_output_tokens",
            b"max_output_tokens",
            "min_context_window",
            b"min_context_window",
            "min_output_tokens",
            b"min_output_tokens",
        ],
    ) -> None: ...

global___TokenRange = TokenRange

@typing.final
class PerformanceRange(google.protobuf.message.Message):
    """PerformanceRange defines minimum performance scores for filtering."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_REASONING_SCORE_FIELD_NUMBER: builtins.int
    MIN_CODING_SCORE_FIELD_NUMBER: builtins.int
    MIN_CREATIVE_SCORE_FIELD_NUMBER: builtins.int
    MIN_FACTUAL_SCORE_FIELD_NUMBER: builtins.int
    MIN_MATH_SCORE_FIELD_NUMBER: builtins.int
    min_reasoning_score: builtins.float
    """Minimum reasoning score (0-10).
    Example: 7.5 for strong reasoning models only
    """
    min_coding_score: builtins.float
    """Minimum coding score (0-10).
    Example: 8.0 for excellent coding models only
    """
    min_creative_score: builtins.float
    """Minimum creative writing score (0-10).
    Example: 7.0 for good creative models only
    """
    min_factual_score: builtins.float
    """Minimum factual accuracy score (0-10).
    Example: 8.5 for highly accurate models only
    """
    min_math_score: builtins.float
    """Minimum mathematical ability score (0-10).
    Example: 9.0 for advanced math models only
    """
    def __init__(
        self,
        *,
        min_reasoning_score: builtins.float = ...,
        min_coding_score: builtins.float = ...,
        min_creative_score: builtins.float = ...,
        min_factual_score: builtins.float = ...,
        min_math_score: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "min_coding_score",
            b"min_coding_score",
            "min_creative_score",
            b"min_creative_score",
            "min_factual_score",
            b"min_factual_score",
            "min_math_score",
            b"min_math_score",
            "min_reasoning_score",
            b"min_reasoning_score",
        ],
    ) -> None: ...

global___PerformanceRange = PerformanceRange

@typing.final
class SearchModelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    FACETS_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    total_count: builtins.int
    @property
    def models(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.llmx.v1.model_pb2.Model
    ]: ...
    @property
    def facets(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___FacetResult
    ]: ...
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[weaveapi.llmx.v1.model_pb2.Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_count: builtins.int = ...,
        facets: collections.abc.Iterable[global___FacetResult] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "facets",
            b"facets",
            "models",
            b"models",
            "next_page_token",
            b"next_page_token",
            "total_count",
            b"total_count",
        ],
    ) -> None: ...

global___SearchModelsResponse = SearchModelsResponse

@typing.final
class FacetResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    field: builtins.str
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___FacetValue
    ]: ...
    def __init__(
        self,
        *,
        field: builtins.str = ...,
        values: collections.abc.Iterable[global___FacetValue] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["field", b"field", "values", b"values"]
    ) -> None: ...

global___FacetResult = FacetResult

@typing.final
class FacetValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    value: builtins.str
    count: builtins.int
    def __init__(
        self,
        *,
        value: builtins.str = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["count", b"count", "value", b"value"]
    ) -> None: ...

global___FacetValue = FacetValue

@typing.final
class CompareModelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_SLUGS_FIELD_NUMBER: builtins.int
    FIELDS_FIELD_NUMBER: builtins.int
    @property
    def model_slugs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """e.g., ["openai/gpt-4o", "anthropic/claude-3-opus"]"""

    @property
    def fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional: specific fields to compare"""

    def __init__(
        self,
        *,
        model_slugs: collections.abc.Iterable[builtins.str] | None = ...,
        fields: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["fields", b"fields", "model_slugs", b"model_slugs"],
    ) -> None: ...

global___CompareModelsRequest = CompareModelsRequest

@typing.final
class CompareModelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPARISONS_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    @property
    def comparisons(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelComparison
    ]: ...
    @property
    def summary(self) -> global___ComparisonSummary: ...
    def __init__(
        self,
        *,
        comparisons: collections.abc.Iterable[global___ModelComparison] | None = ...,
        summary: global___ComparisonSummary | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["summary", b"summary"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "comparisons", b"comparisons", "summary", b"summary"
        ],
    ) -> None: ...

global___CompareModelsResponse = CompareModelsResponse

@typing.final
class ModelComparison(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HighlightedDifferencesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    MODEL_FIELD_NUMBER: builtins.int
    HIGHLIGHTED_DIFFERENCES_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> weaveapi.llmx.v1.model_pb2.Model: ...
    @property
    def highlighted_differences(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        model: weaveapi.llmx.v1.model_pb2.Model | None = ...,
        highlighted_differences: collections.abc.Mapping[builtins.str, builtins.str]
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["model", b"model"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "highlighted_differences", b"highlighted_differences", "model", b"model"
        ],
    ) -> None: ...

global___ModelComparison = ModelComparison

@typing.final
class ComparisonSummary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHEAPEST_INPUT_FIELD_NUMBER: builtins.int
    CHEAPEST_OUTPUT_FIELD_NUMBER: builtins.int
    LARGEST_CONTEXT_FIELD_NUMBER: builtins.int
    BEST_REASONING_FIELD_NUMBER: builtins.int
    BEST_CODING_FIELD_NUMBER: builtins.int
    MOST_CAPABLE_FIELD_NUMBER: builtins.int
    cheapest_input: builtins.str
    cheapest_output: builtins.str
    largest_context: builtins.str
    best_reasoning: builtins.str
    best_coding: builtins.str
    most_capable: builtins.str
    """most capabilities enabled"""
    def __init__(
        self,
        *,
        cheapest_input: builtins.str = ...,
        cheapest_output: builtins.str = ...,
        largest_context: builtins.str = ...,
        best_reasoning: builtins.str = ...,
        best_coding: builtins.str = ...,
        most_capable: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "best_coding",
            b"best_coding",
            "best_reasoning",
            b"best_reasoning",
            "cheapest_input",
            b"cheapest_input",
            "cheapest_output",
            b"cheapest_output",
            "largest_context",
            b"largest_context",
            "most_capable",
            b"most_capable",
        ],
    ) -> None: ...

global___ComparisonSummary = ComparisonSummary

@typing.final
class GetModelPriceHistoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    DAYS_FIELD_NUMBER: builtins.int
    provider: builtins.str
    model_id: builtins.str
    days: builtins.int
    """Last N days (default 30)"""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        model_id: builtins.str = ...,
        days: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "days", b"days", "model_id", b"model_id", "provider", b"provider"
        ],
    ) -> None: ...

global___GetModelPriceHistoryRequest = GetModelPriceHistoryRequest

@typing.final
class GetModelPriceHistoryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRICE_HISTORY_FIELD_NUMBER: builtins.int
    LATEST_CHANGE_FIELD_NUMBER: builtins.int
    @property
    def price_history(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PricePoint
    ]: ...
    @property
    def latest_change(self) -> global___PriceChange: ...
    def __init__(
        self,
        *,
        price_history: collections.abc.Iterable[global___PricePoint] | None = ...,
        latest_change: global___PriceChange | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["latest_change", b"latest_change"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "latest_change", b"latest_change", "price_history", b"price_history"
        ],
    ) -> None: ...

global___GetModelPriceHistoryResponse = GetModelPriceHistoryResponse

@typing.final
class PricePoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    INPUT_PRICE_FIELD_NUMBER: builtins.int
    OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    CACHE_READ_PRICE_FIELD_NUMBER: builtins.int
    CACHE_WRITE_PRICE_FIELD_NUMBER: builtins.int
    input_price: builtins.float
    output_price: builtins.float
    cache_read_price: builtins.float
    cache_write_price: builtins.float
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input_price: builtins.float = ...,
        output_price: builtins.float = ...,
        cache_read_price: builtins.float = ...,
        cache_write_price: builtins.float = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["timestamp", b"timestamp"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cache_read_price",
            b"cache_read_price",
            "cache_write_price",
            b"cache_write_price",
            "input_price",
            b"input_price",
            "output_price",
            b"output_price",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___PricePoint = PricePoint

@typing.final
class PriceChange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGED_AT_FIELD_NUMBER: builtins.int
    OLD_INPUT_PRICE_FIELD_NUMBER: builtins.int
    NEW_INPUT_PRICE_FIELD_NUMBER: builtins.int
    OLD_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    NEW_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    INPUT_CHANGE_PERCENT_FIELD_NUMBER: builtins.int
    OUTPUT_CHANGE_PERCENT_FIELD_NUMBER: builtins.int
    old_input_price: builtins.float
    new_input_price: builtins.float
    old_output_price: builtins.float
    new_output_price: builtins.float
    input_change_percent: builtins.float
    output_change_percent: builtins.float
    @property
    def changed_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        changed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        old_input_price: builtins.float = ...,
        new_input_price: builtins.float = ...,
        old_output_price: builtins.float = ...,
        new_output_price: builtins.float = ...,
        input_change_percent: builtins.float = ...,
        output_change_percent: builtins.float = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["changed_at", b"changed_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "changed_at",
            b"changed_at",
            "input_change_percent",
            b"input_change_percent",
            "new_input_price",
            b"new_input_price",
            "new_output_price",
            b"new_output_price",
            "old_input_price",
            b"old_input_price",
            "old_output_price",
            b"old_output_price",
            "output_change_percent",
            b"output_change_percent",
        ],
    ) -> None: ...

global___PriceChange = PriceChange

@typing.final
class GetModelChangesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    provider: builtins.str
    model_id: builtins.str
    limit: builtins.int
    """Default 20"""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        model_id: builtins.str = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "limit", b"limit", "model_id", b"model_id", "provider", b"provider"
        ],
    ) -> None: ...

global___GetModelChangesRequest = GetModelChangesRequest

@typing.final
class GetModelChangesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGES_FIELD_NUMBER: builtins.int
    @property
    def changes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelChange
    ]: ...
    def __init__(
        self,
        *,
        changes: collections.abc.Iterable[global___ModelChange] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["changes", b"changes"]) -> None: ...

global___GetModelChangesResponse = GetModelChangesResponse

@typing.final
class ModelChange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    OLD_VALUE_FIELD_NUMBER: builtins.int
    NEW_VALUE_FIELD_NUMBER: builtins.int
    CHANGE_TYPE_FIELD_NUMBER: builtins.int
    DETECTED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    field_name: builtins.str
    old_value: builtins.str
    new_value: builtins.str
    change_type: builtins.str
    """added, updated, deprecated, removed"""
    @property
    def detected_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        field_name: builtins.str = ...,
        old_value: builtins.str = ...,
        new_value: builtins.str = ...,
        change_type: builtins.str = ...,
        detected_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["detected_at", b"detected_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "change_type",
            b"change_type",
            "detected_at",
            b"detected_at",
            "field_name",
            b"field_name",
            "id",
            b"id",
            "new_value",
            b"new_value",
            "old_value",
            b"old_value",
        ],
    ) -> None: ...

global___ModelChange = ModelChange

@typing.final
class GetTrendingModelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERIOD_DAYS_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    period_days: builtins.int
    """1, 7, 30"""
    limit: builtins.int
    """Default 10"""
    def __init__(
        self,
        *,
        period_days: builtins.int = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["limit", b"limit", "period_days", b"period_days"],
    ) -> None: ...

global___GetTrendingModelsRequest = GetTrendingModelsRequest

@typing.final
class GetTrendingModelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    @property
    def models(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___TrendingModel
    ]: ...
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___TrendingModel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["models", b"models"]) -> None: ...

global___GetTrendingModelsResponse = GetTrendingModelsResponse

@typing.final
class TrendingModel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    API_CALLS_FIELD_NUMBER: builtins.int
    UNIQUE_USERS_FIELD_NUMBER: builtins.int
    GROWTH_RATE_FIELD_NUMBER: builtins.int
    RANK_FIELD_NUMBER: builtins.int
    api_calls: builtins.int
    unique_users: builtins.int
    growth_rate: builtins.float
    """Percentage"""
    rank: builtins.int
    @property
    def model(self) -> weaveapi.llmx.v1.model_pb2.Model: ...
    def __init__(
        self,
        *,
        model: weaveapi.llmx.v1.model_pb2.Model | None = ...,
        api_calls: builtins.int = ...,
        unique_users: builtins.int = ...,
        growth_rate: builtins.float = ...,
        rank: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["model", b"model"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_calls",
            b"api_calls",
            "growth_rate",
            b"growth_rate",
            "model",
            b"model",
            "rank",
            b"rank",
            "unique_users",
            b"unique_users",
        ],
    ) -> None: ...

global___TrendingModel = TrendingModel

@typing.final
class GetRecentUpdatesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOURS_FIELD_NUMBER: builtins.int
    PROVIDERS_FIELD_NUMBER: builtins.int
    CHANGE_TYPES_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    hours: builtins.int
    """Last N hours (default 24)"""
    limit: builtins.int
    """Default 50"""
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Filter by providers"""

    @property
    def change_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """added, updated, deprecated, removed"""

    def __init__(
        self,
        *,
        hours: builtins.int = ...,
        providers: collections.abc.Iterable[builtins.str] | None = ...,
        change_types: collections.abc.Iterable[builtins.str] | None = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "change_types",
            b"change_types",
            "hours",
            b"hours",
            "limit",
            b"limit",
            "providers",
            b"providers",
        ],
    ) -> None: ...

global___GetRecentUpdatesRequest = GetRecentUpdatesRequest

@typing.final
class GetRecentUpdatesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPDATES_FIELD_NUMBER: builtins.int
    @property
    def updates(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___UpdateEntry
    ]: ...
    def __init__(
        self,
        *,
        updates: collections.abc.Iterable[global___UpdateEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["updates", b"updates"]) -> None: ...

global___GetRecentUpdatesResponse = GetRecentUpdatesResponse

@typing.final
class UpdateEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_SLUG_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    PROVIDER_NAME_FIELD_NUMBER: builtins.int
    CHANGE_TYPE_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    OLD_VALUE_FIELD_NUMBER: builtins.int
    NEW_VALUE_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    DETECTED_AT_FIELD_NUMBER: builtins.int
    model_slug: builtins.str
    model_name: builtins.str
    provider_name: builtins.str
    change_type: builtins.str
    field_name: builtins.str
    old_value: builtins.str
    new_value: builtins.str
    summary: builtins.str
    """Human-readable summary"""
    @property
    def detected_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        model_slug: builtins.str = ...,
        model_name: builtins.str = ...,
        provider_name: builtins.str = ...,
        change_type: builtins.str = ...,
        field_name: builtins.str = ...,
        old_value: builtins.str = ...,
        new_value: builtins.str = ...,
        summary: builtins.str = ...,
        detected_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["detected_at", b"detected_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "change_type",
            b"change_type",
            "detected_at",
            b"detected_at",
            "field_name",
            b"field_name",
            "model_name",
            b"model_name",
            "model_slug",
            b"model_slug",
            "new_value",
            b"new_value",
            "old_value",
            b"old_value",
            "provider_name",
            b"provider_name",
            "summary",
            b"summary",
        ],
    ) -> None: ...

global___UpdateEntry = UpdateEntry

@typing.final
class ExportDataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORMAT_FIELD_NUMBER: builtins.int
    PROVIDERS_FIELD_NUMBER: builtins.int
    INCLUDE_INACTIVE_FIELD_NUMBER: builtins.int
    format: builtins.str
    """"json", "csv", "yaml" """
    include_inactive: builtins.bool
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional filter"""

    def __init__(
        self,
        *,
        format: builtins.str = ...,
        providers: collections.abc.Iterable[builtins.str] | None = ...,
        include_inactive: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "format",
            b"format",
            "include_inactive",
            b"include_inactive",
            "providers",
            b"providers",
        ],
    ) -> None: ...

global___ExportDataRequest = ExportDataRequest

@typing.final
class ExportDataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    MODEL_COUNT_FIELD_NUMBER: builtins.int
    GENERATED_AT_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    content_type: builtins.str
    filename: builtins.str
    model_count: builtins.int
    @property
    def generated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        content_type: builtins.str = ...,
        filename: builtins.str = ...,
        model_count: builtins.int = ...,
        generated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["generated_at", b"generated_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "content_type",
            b"content_type",
            "data",
            b"data",
            "filename",
            b"filename",
            "generated_at",
            b"generated_at",
            "model_count",
            b"model_count",
        ],
    ) -> None: ...

global___ExportDataResponse = ExportDataResponse

@typing.final
class GetStatisticsRequest(google.protobuf.message.Message):
    """Empty for now, might add filters later"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetStatisticsRequest = GetStatisticsRequest

@typing.final
class GetStatisticsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OVERALL_FIELD_NUMBER: builtins.int
    BY_PROVIDER_FIELD_NUMBER: builtins.int
    BY_TYPE_FIELD_NUMBER: builtins.int
    PRICING_FIELD_NUMBER: builtins.int
    RECENT_ACTIVITY_FIELD_NUMBER: builtins.int
    @property
    def overall(self) -> global___OverallStats: ...
    @property
    def by_provider(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ProviderStats
    ]: ...
    @property
    def by_type(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___TypeStats
    ]: ...
    @property
    def pricing(self) -> global___PricingStats: ...
    @property
    def recent_activity(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___RecentActivity
    ]: ...
    def __init__(
        self,
        *,
        overall: global___OverallStats | None = ...,
        by_provider: collections.abc.Iterable[global___ProviderStats] | None = ...,
        by_type: collections.abc.Iterable[global___TypeStats] | None = ...,
        pricing: global___PricingStats | None = ...,
        recent_activity: collections.abc.Iterable[global___RecentActivity] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["overall", b"overall", "pricing", b"pricing"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "by_provider",
            b"by_provider",
            "by_type",
            b"by_type",
            "overall",
            b"overall",
            "pricing",
            b"pricing",
            "recent_activity",
            b"recent_activity",
        ],
    ) -> None: ...

global___GetStatisticsResponse = GetStatisticsResponse

@typing.final
class OverallStats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_PROVIDERS_FIELD_NUMBER: builtins.int
    TOTAL_MODELS_FIELD_NUMBER: builtins.int
    ACTIVE_MODELS_FIELD_NUMBER: builtins.int
    DEPRECATED_MODELS_FIELD_NUMBER: builtins.int
    OPEN_SOURCE_MODELS_FIELD_NUMBER: builtins.int
    LAST_UPDATE_FIELD_NUMBER: builtins.int
    total_providers: builtins.int
    total_models: builtins.int
    active_models: builtins.int
    deprecated_models: builtins.int
    open_source_models: builtins.int
    @property
    def last_update(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        total_providers: builtins.int = ...,
        total_models: builtins.int = ...,
        active_models: builtins.int = ...,
        deprecated_models: builtins.int = ...,
        open_source_models: builtins.int = ...,
        last_update: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["last_update", b"last_update"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_models",
            b"active_models",
            "deprecated_models",
            b"deprecated_models",
            "last_update",
            b"last_update",
            "open_source_models",
            b"open_source_models",
            "total_models",
            b"total_models",
            "total_providers",
            b"total_providers",
        ],
    ) -> None: ...

global___OverallStats = OverallStats

@typing.final
class ProviderStats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_NAME_FIELD_NUMBER: builtins.int
    MODEL_COUNT_FIELD_NUMBER: builtins.int
    ACTIVE_COUNT_FIELD_NUMBER: builtins.int
    AVG_INPUT_PRICE_FIELD_NUMBER: builtins.int
    AVG_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    AVG_CONTEXT_WINDOW_FIELD_NUMBER: builtins.int
    provider_name: builtins.str
    model_count: builtins.int
    active_count: builtins.int
    avg_input_price: builtins.float
    avg_output_price: builtins.float
    avg_context_window: builtins.int
    def __init__(
        self,
        *,
        provider_name: builtins.str = ...,
        model_count: builtins.int = ...,
        active_count: builtins.int = ...,
        avg_input_price: builtins.float = ...,
        avg_output_price: builtins.float = ...,
        avg_context_window: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_count",
            b"active_count",
            "avg_context_window",
            b"avg_context_window",
            "avg_input_price",
            b"avg_input_price",
            "avg_output_price",
            b"avg_output_price",
            "model_count",
            b"model_count",
            "provider_name",
            b"provider_name",
        ],
    ) -> None: ...

global___ProviderStats = ProviderStats

@typing.final
class TypeStats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_TYPE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    PERCENTAGE_FIELD_NUMBER: builtins.int
    model_type: builtins.str
    count: builtins.int
    percentage: builtins.float
    def __init__(
        self,
        *,
        model_type: builtins.str = ...,
        count: builtins.int = ...,
        percentage: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "count", b"count", "model_type", b"model_type", "percentage", b"percentage"
        ],
    ) -> None: ...

global___TypeStats = TypeStats

@typing.final
class PricingStats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MAX_INPUT_PRICE_FIELD_NUMBER: builtins.int
    AVG_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MEDIAN_INPUT_PRICE_FIELD_NUMBER: builtins.int
    MIN_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    AVG_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    MEDIAN_OUTPUT_PRICE_FIELD_NUMBER: builtins.int
    min_input_price: builtins.float
    max_input_price: builtins.float
    avg_input_price: builtins.float
    median_input_price: builtins.float
    min_output_price: builtins.float
    max_output_price: builtins.float
    avg_output_price: builtins.float
    median_output_price: builtins.float
    def __init__(
        self,
        *,
        min_input_price: builtins.float = ...,
        max_input_price: builtins.float = ...,
        avg_input_price: builtins.float = ...,
        median_input_price: builtins.float = ...,
        min_output_price: builtins.float = ...,
        max_output_price: builtins.float = ...,
        avg_output_price: builtins.float = ...,
        median_output_price: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "avg_input_price",
            b"avg_input_price",
            "avg_output_price",
            b"avg_output_price",
            "max_input_price",
            b"max_input_price",
            "max_output_price",
            b"max_output_price",
            "median_input_price",
            b"median_input_price",
            "median_output_price",
            b"median_output_price",
            "min_input_price",
            b"min_input_price",
            "min_output_price",
            b"min_output_price",
        ],
    ) -> None: ...

global___PricingStats = PricingStats

@typing.final
class RecentActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    activity_type: builtins.str
    """"new_model", "price_change", "deprecation" """
    description: builtins.str
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        activity_type: builtins.str = ...,
        description: builtins.str = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["timestamp", b"timestamp"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "activity_type",
            b"activity_type",
            "description",
            b"description",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___RecentActivity = RecentActivity
