"""
    Merge ATS API

    The unified API for building rich integrations with multiple Applicant Tracking System platforms.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: hello@merge.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from MergePythonSDK.shared.api_client import ApiClient, Endpoint as _Endpoint
from MergePythonSDK.shared.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from MergePythonSDK.ats.model.application import Application
from MergePythonSDK.ats.model.application_endpoint_request import ApplicationEndpointRequest
from MergePythonSDK.ats.model.application_response import ApplicationResponse
from MergePythonSDK.ats.model.meta_response import MetaResponse
from MergePythonSDK.shared.model.merge_paginated_response import MergePaginatedResponse
from MergePythonSDK.ats.model.update_application_stage_request import UpdateApplicationStageRequest


class ApplicationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.applications_change_stage_create_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ats/v1/applications/{id}/change-stage',
                'operation_id': 'applications_change_stage_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'is_debug_mode',
                    'run_async',
                    'update_application_stage_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'is_debug_mode':
                        (bool,),
                    'run_async':
                        (bool,),
                    'update_application_stage_request':
                        (UpdateApplicationStageRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'is_debug_mode': 'is_debug_mode',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'id': 'path',
                    'is_debug_mode': 'query',
                    'run_async': 'query',
                    'update_application_stage_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.applications_create_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ats/v1/applications',
                'operation_id': 'applications_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_endpoint_request',
                    'is_debug_mode',
                    'run_async',
                ],
                'required': [
                    'application_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_endpoint_request':
                        (ApplicationEndpointRequest,),
                    'is_debug_mode':
                        (bool,),
                    'run_async':
                        (bool,),
                },
                'attribute_map': {
                    'is_debug_mode': 'is_debug_mode',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'application_endpoint_request': 'body',
                    'is_debug_mode': 'query',
                    'run_async': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.applications_list_endpoint = _Endpoint(
            settings={
                'response_type': (MergePaginatedResponse(Application),),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ats/v1/applications',
                'operation_id': 'applications_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'candidate_id',
                    'created_after',
                    'created_before',
                    'credited_to_id',
                    'current_stage_id',
                    'cursor',
                    'expand',
                    'include_deleted_data',
                    'include_remote_data',
                    'job_id',
                    'modified_after',
                    'modified_before',
                    'page_size',
                    'reject_reason_id',
                    'remote_id',
                    'source',
                ],
                'required': [],
                'nullable': [
                    'remote_id',
                    'source',
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "CANDIDATE": "candidate",
                        "CANDIDATE,CREDITED_TO": "candidate,credited_to",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE": "candidate,credited_to,current_stage",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,credited_to,current_stage,reject_reason",
                        "CANDIDATE,CREDITED_TO,REJECT_REASON": "candidate,credited_to,reject_reason",
                        "CANDIDATE,CURRENT_STAGE": "candidate,current_stage",
                        "CANDIDATE,CURRENT_STAGE,REJECT_REASON": "candidate,current_stage,reject_reason",
                        "CANDIDATE,JOB": "candidate,job",
                        "CANDIDATE,JOB,CREDITED_TO": "candidate,job,credited_to",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE": "candidate,job,credited_to,current_stage",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,job,credited_to,current_stage,reject_reason",
                        "CANDIDATE,JOB,CREDITED_TO,REJECT_REASON": "candidate,job,credited_to,reject_reason",
                        "CANDIDATE,JOB,CURRENT_STAGE": "candidate,job,current_stage",
                        "CANDIDATE,JOB,CURRENT_STAGE,REJECT_REASON": "candidate,job,current_stage,reject_reason",
                        "CANDIDATE,JOB,REJECT_REASON": "candidate,job,reject_reason",
                        "CANDIDATE,REJECT_REASON": "candidate,reject_reason",
                        "CREDITED_TO": "credited_to",
                        "CREDITED_TO,CURRENT_STAGE": "credited_to,current_stage",
                        "CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "credited_to,current_stage,reject_reason",
                        "CREDITED_TO,REJECT_REASON": "credited_to,reject_reason",
                        "CURRENT_STAGE": "current_stage",
                        "CURRENT_STAGE,REJECT_REASON": "current_stage,reject_reason",
                        "JOB": "job",
                        "JOB,CREDITED_TO": "job,credited_to",
                        "JOB,CREDITED_TO,CURRENT_STAGE": "job,credited_to,current_stage",
                        "JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "job,credited_to,current_stage,reject_reason",
                        "JOB,CREDITED_TO,REJECT_REASON": "job,credited_to,reject_reason",
                        "JOB,CURRENT_STAGE": "job,current_stage",
                        "JOB,CURRENT_STAGE,REJECT_REASON": "job,current_stage,reject_reason",
                        "JOB,REJECT_REASON": "job,reject_reason",
                        "REJECT_REASON": "reject_reason"
                    },
                },
                'openapi_types': {
                    'candidate_id':
                        (str,),
                    'created_after':
                        (datetime,),
                    'created_before':
                        (datetime,),
                    'credited_to_id':
                        (str,),
                    'current_stage_id':
                        (str,),
                    'cursor':
                        (str,),
                    'expand':
                        (str,),
                    'include_deleted_data':
                        (bool,),
                    'include_remote_data':
                        (bool,),
                    'job_id':
                        (str,),
                    'modified_after':
                        (datetime,),
                    'modified_before':
                        (datetime,),
                    'page_size':
                        (int,),
                    'reject_reason_id':
                        (str,),
                    'remote_id':
                        (str, none_type,),
                    'source':
                        (str, none_type,),
                },
                'attribute_map': {
                    'candidate_id': 'candidate_id',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'credited_to_id': 'credited_to_id',
                    'current_stage_id': 'current_stage_id',
                    'cursor': 'cursor',
                    'expand': 'expand',
                    'include_deleted_data': 'include_deleted_data',
                    'include_remote_data': 'include_remote_data',
                    'job_id': 'job_id',
                    'modified_after': 'modified_after',
                    'modified_before': 'modified_before',
                    'page_size': 'page_size',
                    'reject_reason_id': 'reject_reason_id',
                    'remote_id': 'remote_id',
                    'source': 'source',
                },
                'location_map': {
                    'candidate_id': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'credited_to_id': 'query',
                    'current_stage_id': 'query',
                    'cursor': 'query',
                    'expand': 'query',
                    'include_deleted_data': 'query',
                    'include_remote_data': 'query',
                    'job_id': 'query',
                    'modified_after': 'query',
                    'modified_before': 'query',
                    'page_size': 'query',
                    'reject_reason_id': 'query',
                    'remote_id': 'query',
                    'source': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.applications_meta_post_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (MetaResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ats/v1/applications/meta/post',
                'operation_id': 'applications_meta_post_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_remote_template_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_remote_template_id':
                        (str,),
                },
                'attribute_map': {
                    'application_remote_template_id': 'application_remote_template_id',
                },
                'location_map': {
                    'application_remote_template_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.applications_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Application,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ats/v1/applications/{id}',
                'operation_id': 'applications_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'expand',
                    'include_remote_data',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "CANDIDATE": "candidate",
                        "CANDIDATE,CREDITED_TO": "candidate,credited_to",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE": "candidate,credited_to,current_stage",
                        "CANDIDATE,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,credited_to,current_stage,reject_reason",
                        "CANDIDATE,CREDITED_TO,REJECT_REASON": "candidate,credited_to,reject_reason",
                        "CANDIDATE,CURRENT_STAGE": "candidate,current_stage",
                        "CANDIDATE,CURRENT_STAGE,REJECT_REASON": "candidate,current_stage,reject_reason",
                        "CANDIDATE,JOB": "candidate,job",
                        "CANDIDATE,JOB,CREDITED_TO": "candidate,job,credited_to",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE": "candidate,job,credited_to,current_stage",
                        "CANDIDATE,JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "candidate,job,credited_to,current_stage,reject_reason",
                        "CANDIDATE,JOB,CREDITED_TO,REJECT_REASON": "candidate,job,credited_to,reject_reason",
                        "CANDIDATE,JOB,CURRENT_STAGE": "candidate,job,current_stage",
                        "CANDIDATE,JOB,CURRENT_STAGE,REJECT_REASON": "candidate,job,current_stage,reject_reason",
                        "CANDIDATE,JOB,REJECT_REASON": "candidate,job,reject_reason",
                        "CANDIDATE,REJECT_REASON": "candidate,reject_reason",
                        "CREDITED_TO": "credited_to",
                        "CREDITED_TO,CURRENT_STAGE": "credited_to,current_stage",
                        "CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "credited_to,current_stage,reject_reason",
                        "CREDITED_TO,REJECT_REASON": "credited_to,reject_reason",
                        "CURRENT_STAGE": "current_stage",
                        "CURRENT_STAGE,REJECT_REASON": "current_stage,reject_reason",
                        "JOB": "job",
                        "JOB,CREDITED_TO": "job,credited_to",
                        "JOB,CREDITED_TO,CURRENT_STAGE": "job,credited_to,current_stage",
                        "JOB,CREDITED_TO,CURRENT_STAGE,REJECT_REASON": "job,credited_to,current_stage,reject_reason",
                        "JOB,CREDITED_TO,REJECT_REASON": "job,credited_to,reject_reason",
                        "JOB,CURRENT_STAGE": "job,current_stage",
                        "JOB,CURRENT_STAGE,REJECT_REASON": "job,current_stage,reject_reason",
                        "JOB,REJECT_REASON": "job,reject_reason",
                        "REJECT_REASON": "reject_reason"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                },
                'location_map': {
                    'id': 'path',
                    'expand': 'query',
                    'include_remote_data': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def applications_change_stage_create(
        self,
        id,
        **kwargs
    ) -> "ApplicationResponse":
        """applications_change_stage_create  # noqa: E501

        Updates the `current_stage` field of an `Application` object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.applications_change_stage_create(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            is_debug_mode (bool): Whether to include debug fields (such as log file links) in the response.. [optional]
            run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
            update_application_stage_request (UpdateApplicationStageRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.applications_change_stage_create_endpoint.call_with_http_info(**kwargs)

    def applications_create(
        self,
        application_endpoint_request,
        **kwargs
    ) -> "ApplicationResponse":
        """applications_create  # noqa: E501

        Creates an `Application` object with the given values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.applications_create(application_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            application_endpoint_request (ApplicationEndpointRequest):

        Keyword Args:
            is_debug_mode (bool): Whether to include debug fields (such as log file links) in the response.. [optional]
            run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['application_endpoint_request'] = \
            application_endpoint_request
        return self.applications_create_endpoint.call_with_http_info(**kwargs)

    def applications_list(
        self,
        **kwargs
    ) -> "MergePaginatedResponse(Application)":
        """applications_list  # noqa: E501

        Returns a list of `Application` objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.applications_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            candidate_id (str): If provided, will only return applications for this candidate.. [optional]
            created_after (datetime): If provided, will only return objects created after this datetime.. [optional]
            created_before (datetime): If provided, will only return objects created before this datetime.. [optional]
            credited_to_id (str): If provided, will only return applications credited to this user.. [optional]
            current_stage_id (str): If provided, will only return applications at this interview stage.. [optional]
            cursor (str): The pagination cursor value.. [optional]
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            include_deleted_data (bool): Whether to include data that was marked as deleted by third party webhooks.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            job_id (str): If provided, will only return applications for this job.. [optional]
            modified_after (datetime): If provided, will only return objects modified after this datetime.. [optional]
            modified_before (datetime): If provided, will only return objects modified before this datetime.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            reject_reason_id (str): If provided, will only return applications with this reject reason.. [optional]
            remote_id (str, none_type): The API provider's ID for the given object.. [optional]
            source (str, none_type): If provided, will only return applications with this source.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MergePaginatedResponse(Application)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.applications_list_endpoint.call_with_http_info(**kwargs)

    def applications_meta_post_retrieve(
        self,
        **kwargs
    ) -> "MetaResponse":
        """applications_meta_post_retrieve  # noqa: E501

        Returns metadata for `Application` POSTs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.applications_meta_post_retrieve(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            application_remote_template_id (str): The template ID associated with the nested application in the request.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MetaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.applications_meta_post_retrieve_endpoint.call_with_http_info(**kwargs)

    def applications_retrieve(
        self,
        id,
        **kwargs
    ) -> "Application":
        """applications_retrieve  # noqa: E501

        Returns an `Application` object with the given `id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.applications_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Application
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.applications_retrieve_endpoint.call_with_http_info(**kwargs)

