"""
Python module generated from Java source file com.google.common.collect.AbstractMapBasedMultimap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.collect import *
from com.google.common.collect.Maps import ViewCachingAbstractMap
from com.google.j2objc.annotations import WeakOuter
from java.io import Serializable
from java.util import AbstractCollection
from java.util import Collections
from java.util import Comparator
from java.util import ConcurrentModificationException
from java.util import Iterator
from java.util import ListIterator
from java.util import NavigableMap
from java.util import NavigableSet
from java.util import RandomAccess
from java.util import SortedMap
from java.util import SortedSet
from java.util import Spliterator
from java.util.function import BiConsumer
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class AbstractMapBasedMultimap(AbstractMultimap, Serializable):
    """
    Basic implementation of the Multimap interface. This class represents a multimap as a map
    that associates each key with a collection of values. All methods of Multimap are
    supported, including those specified as optional in the interface.
    
    To implement a multimap, a subclass must define the method .createCollection(), which
    creates an empty collection of values for a key.
    
    The multimap constructor takes a map that has a single entry for each distinct key. When you
    insert a key-value pair with a key that isn't already in the multimap, `AbstractMapBasedMultimap` calls .createCollection() to create the collection of values
    for that key. The subclass should not call .createCollection() directly, and a new
    instance should be created every time the method is called.
    
    For example, the subclass could pass a java.util.TreeMap during construction, and
    .createCollection() could return a java.util.TreeSet, in which case the
    multimap's iterators would propagate through the keys and values in sorted order.
    
    Keys and values may be null, as long as the underlying collection classes support null
    elements.
    
    The collections created by .createCollection() may or may not allow duplicates. If the
    collection, such as a Set, does not support duplicates, an added key-value pair will
    replace an existing pair with the same key and value, if such a pair is present. With collections
    like List that allow duplicates, the collection will keep the existing key-value pairs
    while adding a new pair.
    
    This class is not threadsafe when any concurrent operations update the multimap, even if the
    underlying map and .createCollection() method return threadsafe classes. Concurrent read
    operations will work correctly. To allow concurrent update operations, wrap your multimap with a
    call to Multimaps.synchronizedMultimap.
    
    For serialization to work, the subclass must specify explicit `readObject` and `writeObject` methods.

    Author(s)
    - Louis Wasserman
    """

    def size(self) -> int:
        ...


    def containsKey(self, key: "Object") -> bool:
        ...


    def put(self, key: "K", value: "V") -> bool:
        ...


    def replaceValues(self, key: "K", values: Iterable["V"]) -> Iterable["V"]:
        """
        
        
        The returned collection is immutable.
        """
        ...


    def removeAll(self, key: "Object") -> Iterable["V"]:
        """
        
        
        The returned collection is immutable.
        """
        ...


    def clear(self) -> None:
        ...


    def get(self, key: "K") -> Iterable["V"]:
        """
        
        
        The returned collection is not serializable.
        """
        ...


    def values(self) -> Iterable["V"]:
        """
        
        
        The iterator generated by the returned collection traverses the values for one key, followed
        by the values of a second key, and so on.
        """
        ...


    def entries(self) -> Iterable["Entry"["K", "V"]]:
        """
        
        
        The iterator generated by the returned collection traverses the values for one key, followed
        by the values of a second key, and so on.
        
        Each entry is an immutable snapshot of a key-value mapping in the multimap, taken at the
        time the entry is returned by a method call to the collection or its iterator.
        """
        ...


    def forEach(self, action: "BiConsumer"["K", "V"]) -> None:
        ...
