"""
Python module generated from Java source file com.google.common.collect.LinkedListMultimap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.annotations import GwtIncompatible
from com.google.common.annotations import J2ktIncompatible
from com.google.common.collect import *
from com.google.errorprone.annotations import CanIgnoreReturnValue
from com.google.j2objc.annotations import WeakOuter
from java.io import IOException
from java.io import ObjectInputStream
from java.io import ObjectOutputStream
from java.io import Serializable
from java.util import AbstractSequentialList
from java.util import ConcurrentModificationException
from java.util import Iterator
from java.util import ListIterator
from java.util import NoSuchElementException
from java.util.function import Consumer
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class LinkedListMultimap(AbstractMultimap, ListMultimap, Serializable):
    """
    An implementation of `ListMultimap` that supports deterministic iteration order for both
    keys and values. The iteration order is preserved across non-distinct key values. For example,
    for the following multimap definition:
    
    ````Multimap<K, V> multimap = LinkedListMultimap.create();
    multimap.put(key1, foo);
    multimap.put(key2, bar);
    multimap.put(key1, baz);````
    
    ... the iteration order for .keys() is `[key1, key2, key1]`, and similarly for
    .entries(). Unlike LinkedHashMultimap, the iteration order is kept consistent
    between keys, entries and values. For example, calling:
    
    ````multimap.remove(key1, foo);````
    
    changes the entries iteration order to `[key2=bar, key1=baz]` and the key iteration
    order to `[key2, key1]`. The .entries() iterator returns mutable map entries, and
    .replaceValues attempts to preserve iteration order as much as possible.
    
    The collections returned by .keySet() and .asMap iterate through the keys in
    the order they were first added to the multimap. Similarly, .get, .removeAll, and
    .replaceValues return collections that iterate through the values in the order they were
    added. The collections generated by .entries(), .keys(), and .values
    iterate across the key-value mappings in the order they were added to the multimap.
    
    The .values() and .entries() methods both return a `List`, instead of
    the `Collection` specified by the ListMultimap interface.
    
    The methods .get, .keySet(), .keys(), .values, .entries(), and .asMap return collections that are views of the multimap. If the
    multimap is modified while an iteration over any of those collections is in progress, except
    through the iterator's methods, the results of the iteration are undefined.
    
    Keys and values may be null. All optional multimap methods are supported, and all returned
    views are modifiable.
    
    This class is not threadsafe when any concurrent operations update the multimap. Concurrent
    read operations will work correctly. To allow concurrent update operations, wrap your multimap
    with a call to Multimaps.synchronizedListMultimap.
    
    See the Guava User Guide article on <a href=
    "https://github.com/google/guava/wiki/NewCollectionTypesExplained#multimap">`Multimap`</a>.

    Author(s)
    - Mike Bostock

    Since
    - 2.0
    """

    @staticmethod
    def create() -> "LinkedListMultimap"["K", "V"]:
        """
        Creates a new, empty `LinkedListMultimap` with the default initial capacity.
        """
        ...


    @staticmethod
    def create(expectedKeys: int) -> "LinkedListMultimap"["K", "V"]:
        """
        Constructs an empty `LinkedListMultimap` with enough capacity to hold the specified
        number of keys without rehashing.

        Arguments
        - expectedKeys: the expected number of distinct keys

        Raises
        - IllegalArgumentException: if `expectedKeys` is negative
        """
        ...


    @staticmethod
    def create(multimap: "Multimap"["K", "V"]) -> "LinkedListMultimap"["K", "V"]:
        """
        Constructs a `LinkedListMultimap` with the same mappings as the specified `Multimap`. The new multimap has the same Multimap.entries() iteration order as the
        input multimap.

        Arguments
        - multimap: the multimap whose contents are copied to this multimap
        """
        ...


    def size(self) -> int:
        ...


    def isEmpty(self) -> bool:
        ...


    def containsKey(self, key: "Object") -> bool:
        ...


    def containsValue(self, value: "Object") -> bool:
        ...


    def put(self, key: "K", value: "V") -> bool:
        """
        Stores a key-value pair in the multimap.

        Arguments
        - key: key to store in the multimap
        - value: value to store in the multimap

        Returns
        - `True` always
        """
        ...


    def replaceValues(self, key: "K", values: Iterable["V"]) -> list["V"]:
        """
        
        
        If any entries for the specified `key` already exist in the multimap, their values are
        changed in-place without affecting the iteration order.
        
        The returned list is immutable and implements java.util.RandomAccess.
        """
        ...


    def removeAll(self, key: "Object") -> list["V"]:
        """
        
        
        The returned list is immutable and implements java.util.RandomAccess.
        """
        ...


    def clear(self) -> None:
        ...


    def get(self, key: "K") -> list["V"]:
        """
        
        
        If the multimap is modified while an iteration over the list is in progress (except through
        the iterator's own `add`, `set` or `remove` operations) the results of the
        iteration are undefined.
        
        The returned list is not serializable and does not have random access.
        """
        ...


    def values(self) -> list["V"]:
        """
        
        
        The iterator generated by the returned collection traverses the values in the order they
        were added to the multimap. Because the values may have duplicates and follow the insertion
        ordering, this method returns a List, instead of the Collection specified in
        the ListMultimap interface.
        """
        ...


    def entries(self) -> list["Entry"["K", "V"]]:
        """
        
        
        The iterator generated by the returned collection traverses the entries in the order they
        were added to the multimap. Because the entries may have duplicates and follow the insertion
        ordering, this method returns a List, instead of the Collection specified in
        the ListMultimap interface.
        
        An entry's Entry.getKey method always returns the same key, regardless of what
        happens subsequently. As long as the corresponding key-value mapping is not removed from the
        multimap, Entry.getValue returns the value from the multimap, which may change over
        time, and Entry.setValue modifies that value. Removing the mapping from the multimap
        does not alter the value returned by `getValue()`, though a subsequent `setValue()`
        call won't update the multimap but will lead to a revised value being returned by `getValue()`.
        """
        ...
