"""
Python module generated from Java source file com.google.common.collect.TreeMultimap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import GwtCompatible
from com.google.common.annotations import GwtIncompatible
from com.google.common.annotations import J2ktIncompatible
from com.google.common.collect import *
from java.io import IOException
from java.io import ObjectInputStream
from java.io import ObjectOutputStream
from java.util import Comparator
from java.util import NavigableMap
from java.util import NavigableSet
from java.util import SortedSet
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class TreeMultimap(AbstractSortedKeySortedSetMultimap):
    """
    Implementation of `Multimap` whose keys and values are ordered by their natural ordering or
    by supplied comparators. In all cases, this implementation uses Comparable.compareTo or
    Comparator.compare instead of Object.equals to determine equivalence of
    instances.
    
    **Warning:** The comparators or comparables used must be *consistent with equals* as
    explained by the Comparable class specification. Otherwise, the resulting multiset will
    violate the general contract of SetMultimap, which is specified in terms of Object.equals.
    
    The collections returned by `keySet` and `asMap` iterate through the keys
    according to the key comparator ordering or the natural ordering of the keys. Similarly, `get`, `removeAll`, and `replaceValues` return collections that iterate through the
    values according to the value comparator ordering or the natural ordering of the values. The
    collections generated by `entries`, `keys`, and `values` iterate across the
    keys according to the above key ordering, and for each key they iterate across the values
    according to the value ordering.
    
    The multimap does not store duplicate key-value pairs. Adding a new key-value pair equal to an
    existing key-value pair has no effect.
    
    Null keys and values are permitted (provided, of course, that the respective comparators
    support them). All optional multimap methods are supported, and all returned views are
    modifiable.
    
    This class is not threadsafe when any concurrent operations update the multimap. Concurrent
    read operations will work correctly. To allow concurrent update operations, wrap your multimap
    with a call to Multimaps.synchronizedSortedSetMultimap.
    
    See the Guava User Guide article on <a href=
    "https://github.com/google/guava/wiki/NewCollectionTypesExplained#multimap">`Multimap`</a>.

    Author(s)
    - Louis Wasserman

    Since
    - 2.0
    """

    @staticmethod
    def create() -> "TreeMultimap"["K", "V"]:
        """
        Creates an empty `TreeMultimap` ordered by the natural ordering of its keys and values.
        """
        ...


    @staticmethod
    def create(keyComparator: "Comparator"["K"], valueComparator: "Comparator"["V"]) -> "TreeMultimap"["K", "V"]:
        """
        Creates an empty `TreeMultimap` instance using explicit comparators. Neither comparator
        may be null; use Ordering.natural() to specify natural order.

        Arguments
        - keyComparator: the comparator that determines the key ordering
        - valueComparator: the comparator that determines the value ordering
        """
        ...


    @staticmethod
    def create(multimap: "Multimap"["K", "V"]) -> "TreeMultimap"["K", "V"]:
        """
        Constructs a `TreeMultimap`, ordered by the natural ordering of its keys and values, with
        the same mappings as the specified multimap.

        Arguments
        - multimap: the multimap whose contents are copied to this multimap
        """
        ...


    def keyComparator(self) -> "Comparator"["K"]:
        """
        Returns the comparator that orders the multimap keys.

        Deprecated
        - Use `((NavigableSet<K>) multimap.keySet()).comparator()` instead.
        """
        ...


    def valueComparator(self) -> "Comparator"["V"]:
        ...


    def get(self, key: "K") -> "NavigableSet"["V"]:
        """
        Since
        - 14.0 (present with return type `SortedSet` since 2.0)
        """
        ...


    def keySet(self) -> "NavigableSet"["K"]:
        """
        
        
        Because a `TreeMultimap` has unique sorted keys, this method returns a NavigableSet, instead of the java.util.Set specified in the Multimap
        interface.

        Since
        - 14.0 (present with return type `SortedSet` since 2.0)
        """
        ...


    def asMap(self) -> "NavigableMap"["K", Iterable["V"]]:
        """
        
        
        Because a `TreeMultimap` has unique sorted keys, this method returns a NavigableMap, instead of the java.util.Map specified in the Multimap
        interface.

        Since
        - 14.0 (present with return type `SortedMap` since 2.0)
        """
        ...
