"""
Python module generated from Java source file com.google.common.hash.BloomFilter

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.annotations import Beta
from com.google.common.annotations import VisibleForTesting
from com.google.common.base import Objects
from com.google.common.base import Predicate
from com.google.common.hash import *
from com.google.common.hash.BloomFilterStrategies import LockFreeBitArray
from com.google.common.math import DoubleMath
from com.google.common.math import LongMath
from com.google.common.primitives import SignedBytes
from com.google.common.primitives import UnsignedBytes
from com.google.errorprone.annotations import CanIgnoreReturnValue
from java.io import DataInputStream
from java.io import DataOutputStream
from java.io import IOException
from java.io import InputStream
from java.io import InvalidObjectException
from java.io import ObjectInputStream
from java.io import OutputStream
from java.io import Serializable
from java.math import RoundingMode
from java.util.stream import Collector
from javax.annotation import CheckForNull
from org.checkerframework.checker.nullness.qual import Nullable
from typing import Any, Callable, Iterable, Tuple


class BloomFilter(Predicate, Serializable):
    """
    A Bloom filter for instances of `T`. A Bloom filter offers an approximate containment test
    with one-sided error: if it claims that an element is contained in it, this might be in error,
    but if it claims that an element is *not* contained in it, then this is definitely True.
    
    If you are unfamiliar with Bloom filters, this nice <a
    href="http://llimllib.github.io/bloomfilter-tutorial/">tutorial</a> may help you understand how
    they work.
    
    The False positive probability (`FPP`) of a Bloom filter is defined as the probability
    that .mightContain(Object) will erroneously return `True` for an object that
    has not actually been put in the `BloomFilter`.
    
    Bloom filters are serializable. They also support a more compact serial representation via the
    .writeTo and .readFrom methods. Both serialized forms will continue to be
    supported by future versions of this library. However, serial forms generated by newer versions
    of the code may not be readable by older versions of the code (e.g., a serialized Bloom filter
    generated today may *not* be readable by a binary that was compiled 6 months ago).
    
    As of Guava 23.0, this class is thread-safe and lock-free. It internally uses atomics and
    compare-and-swap to ensure correctness when multiple threads are used to access it.
    
    Type `<T>`: the type of instances that the `BloomFilter` accepts

    Author(s)
    - Kevin Bourrillion

    Since
    - 11.0 (thread-safe since 23.0)
    """

    def copy(self) -> "BloomFilter"["T"]:
        """
        Creates a new `BloomFilter` that's a copy of this instance. The new instance is equal to
        this instance but shares no mutable state.

        Since
        - 12.0
        """
        ...


    def mightContain(self, object: "T") -> bool:
        """
        Returns `True` if the element *might* have been put in this Bloom filter, `False` if this is *definitely* not the case.
        """
        ...


    def apply(self, input: "T") -> bool:
        """
        Deprecated
        - Provided only to satisfy the Predicate interface; use .mightContain
            instead.
        """
        ...


    def put(self, object: "T") -> bool:
        """
        Puts an element into this `BloomFilter`. Ensures that subsequent invocations of .mightContain(Object) with the same element will always return `True`.

        Returns
        - True if the Bloom filter's bits changed as a result of this operation. If the bits
            changed, this is *definitely* the first time `object` has been added to the
            filter. If the bits haven't changed, this *might* be the first time `object` has
            been added to the filter. Note that `put(t)` always returns the *opposite*
            result to what `mightContain(t)` would have returned at the time it is called.

        Since
        - 12.0 (present in 11.0 with `void` return type})
        """
        ...


    def expectedFpp(self) -> float:
        """
        Returns the probability that .mightContain(Object) will erroneously return `True` for an object that has not actually been put in the `BloomFilter`.
        
        Ideally, this number should be close to the `fpp` parameter passed in .create(Funnel, int, double), or smaller. If it is significantly higher, it is usually the
        case that too many elements (more than expected) have been put in the `BloomFilter`,
        degenerating it.

        Since
        - 14.0 (since 11.0 as expectedFalsePositiveProbability())
        """
        ...


    def approximateElementCount(self) -> int:
        """
        Returns an estimate for the total number of distinct elements that have been added to this
        Bloom filter. This approximation is reasonably accurate if it does not exceed the value of
        `expectedInsertions` that was used when constructing the filter.

        Since
        - 22.0
        """
        ...


    def isCompatible(self, that: "BloomFilter"["T"]) -> bool:
        """
        Determines whether a given Bloom filter is compatible with this Bloom filter. For two Bloom
        filters to be compatible, they must:
        
        
          - not be the same instance
          - have the same number of hash functions
          - have the same bit size
          - have the same strategy
          - have equal funnels

        Arguments
        - that: The Bloom filter to check for compatibility.

        Since
        - 15.0
        """
        ...


    def putAll(self, that: "BloomFilter"["T"]) -> None:
        """
        Combines this Bloom filter with another Bloom filter by performing a bitwise OR of the
        underlying data. The mutations happen to **this** instance. Callers must ensure the Bloom
        filters are appropriately sized to avoid saturating them.

        Arguments
        - that: The Bloom filter to combine this Bloom filter with. It is not mutated.

        Raises
        - IllegalArgumentException: if `isCompatible(that) == False`

        Since
        - 15.0
        """
        ...


    def equals(self, object: "Object") -> bool:
        ...


    def hashCode(self) -> int:
        ...


    @staticmethod
    def toBloomFilter(funnel: "Funnel"["T"], expectedInsertions: int) -> "Collector"["T", Any, "BloomFilter"["T"]]:
        """
        Returns a `Collector` expecting the specified number of insertions, and yielding a BloomFilter with False positive probability 3%.
        
        Note that if the `Collector` receives significantly more elements than specified, the
        resulting `BloomFilter` will suffer a sharp deterioration of its False positive
        probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive

        Returns
        - a `Collector` generating a `BloomFilter` of the received elements

        Since
        - 23.0
        """
        ...


    @staticmethod
    def toBloomFilter(funnel: "Funnel"["T"], expectedInsertions: int, fpp: float) -> "Collector"["T", Any, "BloomFilter"["T"]]:
        """
        Returns a `Collector` expecting the specified number of insertions, and yielding a BloomFilter with the specified expected False positive probability.
        
        Note that if the `Collector` receives significantly more elements than specified, the
        resulting `BloomFilter` will suffer a sharp deterioration of its False positive
        probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive
        - fpp: the desired False positive probability (must be positive and less than 1.0)

        Returns
        - a `Collector` generating a `BloomFilter` of the received elements

        Since
        - 23.0
        """
        ...


    @staticmethod
    def create(funnel: "Funnel"["T"], expectedInsertions: int, fpp: float) -> "BloomFilter"["T"]:
        """
        Creates a BloomFilter with the expected number of insertions and expected False
        positive probability.
        
        Note that overflowing a `BloomFilter` with significantly more elements than specified,
        will result in its saturation, and a sharp deterioration of its False positive probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive
        - fpp: the desired False positive probability (must be positive and less than 1.0)

        Returns
        - a `BloomFilter`
        """
        ...


    @staticmethod
    def create(funnel: "Funnel"["T"], expectedInsertions: int, fpp: float) -> "BloomFilter"["T"]:
        """
        Creates a BloomFilter with the expected number of insertions and expected False
        positive probability.
        
        Note that overflowing a `BloomFilter` with significantly more elements than specified,
        will result in its saturation, and a sharp deterioration of its False positive probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive
        - fpp: the desired False positive probability (must be positive and less than 1.0)

        Returns
        - a `BloomFilter`

        Since
        - 19.0
        """
        ...


    @staticmethod
    def create(funnel: "Funnel"["T"], expectedInsertions: int) -> "BloomFilter"["T"]:
        """
        Creates a BloomFilter with the expected number of insertions and a default expected
        False positive probability of 3%.
        
        Note that overflowing a `BloomFilter` with significantly more elements than specified,
        will result in its saturation, and a sharp deterioration of its False positive probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive

        Returns
        - a `BloomFilter`
        """
        ...


    @staticmethod
    def create(funnel: "Funnel"["T"], expectedInsertions: int) -> "BloomFilter"["T"]:
        """
        Creates a BloomFilter with the expected number of insertions and a default expected
        False positive probability of 3%.
        
        Note that overflowing a `BloomFilter` with significantly more elements than specified,
        will result in its saturation, and a sharp deterioration of its False positive probability.
        
        The constructed `BloomFilter` will be serializable if the provided `Funnel<T>`
        is.
        
        It is recommended that the funnel be implemented as a Java enum. This has the benefit of
        ensuring proper serialization and deserialization, which is important since .equals
        also relies on object identity of funnels.

        Arguments
        - funnel: the funnel of T's that the constructed `BloomFilter` will use
        - expectedInsertions: the number of expected insertions to the constructed `BloomFilter`; must be positive

        Returns
        - a `BloomFilter`

        Since
        - 19.0
        """
        ...


    def writeTo(self, out: "OutputStream") -> None:
        """
        Writes this `BloomFilter` to an output stream, with a custom format (not Java
        serialization). This has been measured to save at least 400 bytes compared to regular
        serialization.
        
        Use .readFrom(InputStream, Funnel) to reconstruct the written BloomFilter.
        """
        ...


    @staticmethod
    def readFrom(in: "InputStream", funnel: "Funnel"["T"]) -> "BloomFilter"["T"]:
        """
        Reads a byte stream, which was written by .writeTo(OutputStream), into a `BloomFilter`.
        
        The `Funnel` to be used is not encoded in the stream, so it must be provided here.
        **Warning:** the funnel provided **must** behave identically to the one used to populate
        the original Bloom filter!

        Raises
        - IOException: if the InputStream throws an `IOException`, or if its data does not
            appear to be a BloomFilter serialized using the .writeTo(OutputStream) method.
        """
        ...
