"""
Python module generated from Java source file java.io.ByteArrayInputStream

Java source file obtained from artifact jdk version jdk

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from java.io import *
from java.util import Arrays
from java.util import Objects
from typing import Any, Callable, Iterable, Tuple


class ByteArrayInputStream(InputStream):
    """
    A `ByteArrayInputStream` contains
    an internal buffer that contains bytes that
    may be read from the stream. An internal
    counter keeps track of the next byte to
    be supplied by the `read` method.
    
    Closing a `ByteArrayInputStream` has no effect. The methods in
    this class can be called after the stream has been closed without
    generating an `IOException`.

    Author(s)
    - Arthur van Hoff

    See
    - java.io.StringBufferInputStream

    Since
    - 1.0
    """

    def __init__(self, buf: list[int]):
        """
        Creates a `ByteArrayInputStream`
        so that it  uses `buf` as its
        buffer array.
        The buffer array is not copied.
        The initial value of `pos`
        is `0` and the initial value
        of  `count` is the length of
        `buf`.

        Arguments
        - buf: the input buffer.
        """
        ...


    def __init__(self, buf: list[int], offset: int, length: int):
        """
        Creates `ByteArrayInputStream`
        that uses `buf` as its
        buffer array. The initial value of `pos`
        is `offset` and the initial value
        of `count` is the minimum of `offset+length`
        and `buf.length`.
        The buffer array is not copied. The buffer's mark is
        set to the specified offset.

        Arguments
        - buf: the input buffer.
        - offset: the offset in the buffer of the first byte to read.
        - length: the maximum number of bytes to read from the buffer.
        """
        ...


    def read(self) -> int:
        """
        Reads the next byte of data from this input stream. The value
        byte is returned as an `int` in the range
        `0` to `255`. If no byte is available
        because the end of the stream has been reached, the value
        `-1` is returned.
        
        This `read` method
        cannot block.

        Returns
        - the next byte of data, or `-1` if the end of the
                 stream has been reached.
        """
        ...


    def read(self, b: list[int], off: int, len: int) -> int:
        """
        Reads up to `len` bytes of data into an array of bytes from this
        input stream.  If `pos` equals `count`, then `-1` is
        returned to indicate end of file.  Otherwise, the  number `k` of
        bytes read is equal to the smaller of `len` and `count-pos`.
        If `k` is positive, then bytes `buf[pos]` through
        `buf[pos+k-1]` are copied into `b[off]` through
        `b[off+k-1]` in the manner performed by `System.arraycopy`.
        The value `k` is added into `pos` and `k` is returned.
        
        Unlike the InputStream.read(byte[],int,int) overridden method
        of `InputStream`, this method returns `-1` instead of zero
        if the end of the stream has been reached and `len == 0`.
        
        This `read` method cannot block.

        Arguments
        - b: the buffer into which the data is read.
        - off: the start offset in the destination array `b`
        - len: the maximum number of bytes read.

        Returns
        - the total number of bytes read into the buffer, or
                 `-1` if there is no more data because the end of
                 the stream has been reached.

        Raises
        - NullPointerException: If `b` is `null`.
        - IndexOutOfBoundsException: If `off` is negative,
        `len` is negative, or `len` is greater than
        `b.length - off`
        """
        ...


    def readAllBytes(self) -> list[int]:
        ...


    def readNBytes(self, b: list[int], off: int, len: int) -> int:
        ...


    def transferTo(self, out: "OutputStream") -> int:
        ...


    def skip(self, n: int) -> int:
        """
        Skips `n` bytes of input from this input stream. Fewer
        bytes might be skipped if the end of the input stream is reached.
        The actual number `k`
        of bytes to be skipped is equal to the smaller
        of `n` and  `count-pos`.
        The value `k` is added into `pos`
        and `k` is returned.

        Arguments
        - n: the number of bytes to be skipped.

        Returns
        - the actual number of bytes skipped.
        """
        ...


    def available(self) -> int:
        """
        Returns the number of remaining bytes that can be read (or skipped over)
        from this input stream.
        
        The value returned is `count - pos`,
        which is the number of bytes remaining to be read from the input buffer.

        Returns
        - the number of remaining bytes that can be read (or skipped
                 over) from this input stream without blocking.
        """
        ...


    def markSupported(self) -> bool:
        """
        Tests if this `InputStream` supports mark/reset. The
        `markSupported` method of `ByteArrayInputStream`
        always returns `True`.

        Since
        - 1.1
        """
        ...


    def mark(self, readAheadLimit: int) -> None:
        """
        Set the current marked position in the stream.
        ByteArrayInputStream objects are marked at position zero by
        default when constructed.  They may be marked at another
        position within the buffer by this method.
        
        If no mark has been set, then the value of the mark is the
        offset passed to the constructor (or 0 if the offset was not
        supplied).
        
         Note: The `readAheadLimit` for this class
         has no meaning.

        Since
        - 1.1
        """
        ...


    def reset(self) -> None:
        """
        Resets the buffer to the marked position.  The marked position
        is 0 unless another position was marked or an offset was specified
        in the constructor.
        """
        ...


    def close(self) -> None:
        """
        Closing a `ByteArrayInputStream` has no effect. The methods in
        this class can be called after the stream has been closed without
        generating an `IOException`.
        """
        ...
