"""
Python module generated from Java source file org.bukkit.NamespacedKey

Java source file obtained from artifact spigot-api version 1.20.3-R0.1-20231207.085553-9

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.base import Preconditions
from java.util import Locale
from java.util import UUID
from org.bukkit import *
from org.bukkit.plugin import Plugin
from typing import Any, Callable, Iterable, Tuple


class NamespacedKey:
    """
    Represents a String based key which consists of two components - a namespace
    and a key.
    
    Namespaces may only contain lowercase alphanumeric characters, periods,
    underscores, and hyphens.
    
    Keys may only contain lowercase alphanumeric characters, periods,
    underscores, hyphens, and forward slashes.
    """

    MINECRAFT = "minecraft"
    """
    The namespace representing all inbuilt keys.
    """
    BUKKIT = "bukkit"
    """
    The namespace representing all keys generated by Bukkit for backwards
    compatibility measures.
    """


    def __init__(self, namespace: str, key: str):
        """
        Create a key in a specific namespace.

        Arguments
        - namespace: namespace
        - key: key

        Unknown Tags
        - should never be used by plugins, for internal use only!!
        """
        ...


    def __init__(self, plugin: "Plugin", key: str):
        """
        Create a key in the plugin's namespace.
        
        Namespaces may only contain lowercase alphanumeric characters, periods,
        underscores, and hyphens.
        
        Keys may only contain lowercase alphanumeric characters, periods,
        underscores, hyphens, and forward slashes.

        Arguments
        - plugin: the plugin to use for the namespace
        - key: the key to create
        """
        ...


    def getNamespace(self) -> str:
        ...


    def getKey(self) -> str:
        ...


    def hashCode(self) -> int:
        ...


    def equals(self, obj: "Object") -> bool:
        ...


    def toString(self) -> str:
        ...


    @staticmethod
    def randomKey() -> "NamespacedKey":
        """
        Return a new random key in the .BUKKIT namespace.

        Returns
        - new key

        Deprecated
        - should never be used by plugins, for internal use only!!
        """
        ...


    @staticmethod
    def minecraft(key: str) -> "NamespacedKey":
        """
        Get a key in the Minecraft namespace.

        Arguments
        - key: the key to use

        Returns
        - new key in the Minecraft namespace
        """
        ...


    @staticmethod
    def fromString(string: str, defaultNamespace: "Plugin") -> "NamespacedKey":
        """
        Get a NamespacedKey from the supplied string with a default namespace if
        a namespace is not defined. This is a utility method meant to fetch a
        NamespacedKey from user input. Please note that casing does matter and
        any instance of uppercase characters will be considered invalid. The
        input contract is as follows:
        ```
        fromString("foo", plugin) -> "plugin:foo"
        fromString("foo:bar", plugin) -> "foo:bar"
        fromString(":foo", null) -> "minecraft:foo"
        fromString("foo", null) -> "minecraft:foo"
        fromString("Foo", plugin) -> null
        fromString(":Foo", plugin) -> null
        fromString("foo:bar:bazz", plugin) -> null
        fromString("", plugin) -> null
        ```

        Arguments
        - string: the string to convert to a NamespacedKey
        - defaultNamespace: the default namespace to use if none was
        supplied. If null, the `minecraft` namespace
        (.minecraft(String)) will be used

        Returns
        - the created NamespacedKey. null if invalid key

        See
        - .fromString(String)
        """
        ...


    @staticmethod
    def fromString(key: str) -> "NamespacedKey":
        """
        Get a NamespacedKey from the supplied string.
        
        The default namespace will be Minecraft's (i.e.
        .minecraft(String)).

        Arguments
        - key: the key to convert to a NamespacedKey

        Returns
        - the created NamespacedKey. null if invalid

        See
        - .fromString(String, Plugin)
        """
        ...
