"""
Python module generated from Java source file org.bukkit.event.block.SculkBloomEvent

Java source file obtained from artifact spigot-api version 1.20.3-R0.1-20231207.085553-9

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.base import Preconditions
from org.bukkit.block import Block
from org.bukkit.block import SculkCatalyst
from org.bukkit.event import Cancellable
from org.bukkit.event import HandlerList
from org.bukkit.event.block import *
from org.bukkit.event.entity import EntityDeathEvent
from typing import Any, Callable, Iterable, Tuple


class SculkBloomEvent(BlockEvent, Cancellable):
    """
    Represents an event triggered when a new cursor is created by a SculkCatalyst.
    
    <strong>Cursor Definition:</strong>
    A cursor in this context is a dynamic marker or pointer generated by the
    SculkCatalyst. It occupies a block and spreads sculk as it moves. It is
    similar to entity, but it is not an entity. Cursors are ticked by the
    tile entity.
    
    <strong>Triggers for Cursor Creation:</strong>
    
      - An entity, when killed and drops experience, within an 8-block radius of a SculkCatalyst.
      - An explicit call from a plugin using SculkCatalyst.bloom(Block, int).
    
    
    The result of .getBlock() is the location that the cursor is spawning at.
    """

    def __init__(self, theBlock: "Block", charge: int):
        ...


    def getCharge(self) -> int:
        """
        Returns the charge of the cursor, &lt; 1000 by default.

        Returns
        - the charge of the cursor
        """
        ...


    def setCharge(self, charge: int) -> None:
        """
        Sets the charge of the cursor.
        
        Increasing the charge of a cursor makes the cursor last longer, giving
        it more time to spread sculk blocks across a larger range.
        
        Typically, charges should be set to the exp reward of a mob
        (EntityDeathEvent.getDroppedExp()), which is usually
        3-5 for animals, and 5-10 for the average mob (up to 50 for
        wither skeletons). Roughly speaking, for each charge, 1 more
        sculk block will be placed.

        Arguments
        - charge: the charge of the cursor.
        """
        ...


    def isCancelled(self) -> bool:
        ...


    def setCancelled(self, cancel: bool) -> None:
        ...


    def getHandlers(self) -> "HandlerList":
        ...


    @staticmethod
    def getHandlerList() -> "HandlerList":
        ...
