# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_ast.ipynb.

# %% auto 0
__all__ = ['last_node', 'node_source', 'is_assignment', 'extract_call', 'is_function_call', 'is_import_statement', 'is_ast_node',
           'need_display', 'wrap_node', 'last_statement_has_semicolon', 'code_till_node', 'auto_display']

# %% ../nbs/01_ast.ipynb 3
import ast

# %% ../nbs/01_ast.ipynb 5
def last_node(code):
    tree = ast.parse(code)
    if len(tree.body)==0: return None
    src = tree.body[-1]
    last_node = None
    parent_node = None
    for node in ast.walk(src):
        if isinstance(node, ast.stmt):
            parent_node = last_node
            last_node = node
    if parent_node is not None: return None # deal with nested statements like "for loop".
    return last_node

# %% ../nbs/01_ast.ipynb 7
def node_source(node,code):
    return ast.get_source_segment(code,node)

# %% ../nbs/01_ast.ipynb 13
def is_assignment(node):
    return isinstance(node, ast.Assign)

# %% ../nbs/01_ast.ipynb 15
def extract_call(node):
    if not isinstance(node, ast.Expr): return None
    node = node.value # step in
    if isinstance(node, ast.Name): return None # "fn"
    if isinstance(node, ast.Call):
        n = node.func # step in
        if isinstance(n, ast.Name): return n.id # "fn()"
        if isinstance(n, ast.Attribute): return n.attr
    return None # all the rest is not supported

# %% ../nbs/01_ast.ipynb 17
def is_function_call(node,names):
    function_name = extract_call(node)
    if function_name is None: return False # this is not a function call
    return function_name in names

# %% ../nbs/01_ast.ipynb 19
def is_import_statement(node):
    return isinstance(node, (ast.Import, ast.ImportFrom))

# %% ../nbs/01_ast.ipynb 21
def is_ast_node(x,ref):
    for t in ref:
        if isinstance(x,t): return True
    return False

# %% ../nbs/01_ast.ipynb 24
def need_display(node):
    if node is None: return False
    if is_assignment(node): return False
    if is_function_call(node,names=['print','display']): return False
    if is_ast_node(node,ref=[ast.Delete, ast.Assert, ast.Global, ast.Nonlocal]): return False
    if is_import_statement(node): return False
    return True

# %% ../nbs/01_ast.ipynb 26
def wrap_node(node,function_name):
    return ast.Expr(
        value=ast.Call(
            func=ast.Name(id=function_name, ctx=ast.Load()),
            args=[node],
            keywords=[])
        )

# %% ../nbs/01_ast.ipynb 29
def last_statement_has_semicolon(code):
    t = [x.strip() for x in code.splitlines()]
    t = [x for x in t if not x.startswith('#')]
    return t[-1].endswith(';')

# %% ../nbs/01_ast.ipynb 31
def code_till_node(code:str,node):
    t = code.splitlines()
    t = t[:node.lineno]
    t[-1] = t[-1][:node.col_offset]
    if len(t[-1])==0: t = t[:-1]
    return '\n'.join(t)

# %% ../nbs/01_ast.ipynb 34
def auto_display(code):
    if last_statement_has_semicolon(code): return code
    
    n = last_node(code)
    if not need_display(n): return code
    
    ns = node_source(n,code)
    ret = code_till_node(code, last_node(code))
    ret += f'\ndisplay( # %%testcell\n{ns}\n) # %%testcell'
    return ret
