# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFleetResourceResult',
    'AwaitableGetFleetResourceResult',
    'get_fleet_resource',
    'get_fleet_resource_output',
]

@pulumi.output_type
class GetFleetResourceResult:
    """
    A collection of values returned by getFleetResource.
    """
    def __init__(__self__, application_type=None, compartment=None, compartment_id=None, compliance_state=None, display_name=None, environment_type=None, fleet_id=None, fleet_resource_id=None, id=None, lifecycle_details=None, product=None, product_count=None, resource_id=None, resource_region=None, resource_type=None, state=None, system_tags=None, target_count=None, tenancy_id=None, tenancy_name=None, time_created=None, time_updated=None):
        if application_type and not isinstance(application_type, str):
            raise TypeError("Expected argument 'application_type' to be a str")
        pulumi.set(__self__, "application_type", application_type)
        if compartment and not isinstance(compartment, str):
            raise TypeError("Expected argument 'compartment' to be a str")
        pulumi.set(__self__, "compartment", compartment)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_state and not isinstance(compliance_state, str):
            raise TypeError("Expected argument 'compliance_state' to be a str")
        pulumi.set(__self__, "compliance_state", compliance_state)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_resource_id and not isinstance(fleet_resource_id, str):
            raise TypeError("Expected argument 'fleet_resource_id' to be a str")
        pulumi.set(__self__, "fleet_resource_id", fleet_resource_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if product_count and not isinstance(product_count, int):
            raise TypeError("Expected argument 'product_count' to be a int")
        pulumi.set(__self__, "product_count", product_count)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_count and not isinstance(target_count, int):
            raise TypeError("Expected argument 'target_count' to be a int")
        pulumi.set(__self__, "target_count", target_count)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if tenancy_name and not isinstance(tenancy_name, str):
            raise TypeError("Expected argument 'tenancy_name' to be a str")
        pulumi.set(__self__, "tenancy_name", tenancy_name)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> str:
        """
        Application Type associated with the resource when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter
    def compartment(self) -> str:
        """
        Resource Compartment name.
        """
        return pulumi.get(self, "compartment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Compliance State of the Resource.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        Environment Type associated with the Fleet when the resource type is fleet. Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetResourceId")
    def fleet_resource_id(self) -> str:
        return pulumi.get(self, "fleet_resource_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Product associated with the resource when the resource type is fleet. Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="productCount")
    def product_count(self) -> int:
        """
        Count of products within the resource.
        """
        return pulumi.get(self, "product_count")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the Resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the FleetResource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> int:
        """
        Count of targets within the resource.
        """
        return pulumi.get(self, "target_count")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        OCID of the tenancy to which the resource belongs to.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> str:
        """
        Resource Tenancy Name.
        """
        return pulumi.get(self, "tenancy_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFleetResourceResult(GetFleetResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetResourceResult(
            application_type=self.application_type,
            compartment=self.compartment,
            compartment_id=self.compartment_id,
            compliance_state=self.compliance_state,
            display_name=self.display_name,
            environment_type=self.environment_type,
            fleet_id=self.fleet_id,
            fleet_resource_id=self.fleet_resource_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            product=self.product,
            product_count=self.product_count,
            resource_id=self.resource_id,
            resource_region=self.resource_region,
            resource_type=self.resource_type,
            state=self.state,
            system_tags=self.system_tags,
            target_count=self.target_count,
            tenancy_id=self.tenancy_id,
            tenancy_name=self.tenancy_name,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_fleet_resource(fleet_id: Optional[str] = None,
                       fleet_resource_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetResourceResult:
    """
    This data source provides details about a specific Fleet Resource resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Fleet Resource by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_resource = oci.FleetAppsManagement.get_fleet_resource(fleet_id=test_fleet["id"],
        fleet_resource_id=test_resource["id"])
    ```


    :param str fleet_id: Unique Fleet identifier.
    :param str fleet_resource_id: unique FleetResource identifier
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['fleetResourceId'] = fleet_resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetResource:getFleetResource', __args__, opts=opts, typ=GetFleetResourceResult).value

    return AwaitableGetFleetResourceResult(
        application_type=pulumi.get(__ret__, 'application_type'),
        compartment=pulumi.get(__ret__, 'compartment'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_state=pulumi.get(__ret__, 'compliance_state'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_type=pulumi.get(__ret__, 'environment_type'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_resource_id=pulumi.get(__ret__, 'fleet_resource_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        product=pulumi.get(__ret__, 'product'),
        product_count=pulumi.get(__ret__, 'product_count'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_count=pulumi.get(__ret__, 'target_count'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        tenancy_name=pulumi.get(__ret__, 'tenancy_name'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_fleet_resource_output(fleet_id: Optional[pulumi.Input[str]] = None,
                              fleet_resource_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetResourceResult]:
    """
    This data source provides details about a specific Fleet Resource resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Fleet Resource by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_resource = oci.FleetAppsManagement.get_fleet_resource(fleet_id=test_fleet["id"],
        fleet_resource_id=test_resource["id"])
    ```


    :param str fleet_id: Unique Fleet identifier.
    :param str fleet_resource_id: unique FleetResource identifier
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['fleetResourceId'] = fleet_resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetResource:getFleetResource', __args__, opts=opts, typ=GetFleetResourceResult)
    return __ret__.apply(lambda __response__: GetFleetResourceResult(
        application_type=pulumi.get(__response__, 'application_type'),
        compartment=pulumi.get(__response__, 'compartment'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_state=pulumi.get(__response__, 'compliance_state'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment_type=pulumi.get(__response__, 'environment_type'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_resource_id=pulumi.get(__response__, 'fleet_resource_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        product=pulumi.get(__response__, 'product'),
        product_count=pulumi.get(__response__, 'product_count'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_count=pulumi.get(__response__, 'target_count'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        tenancy_name=pulumi.get(__response__, 'tenancy_name'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
