# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetDeploymentResult',
    'AwaitableGetDeploymentResult',
    'get_deployment',
    'get_deployment_output',
]

@pulumi.output_type
class GetDeploymentResult:
    """
    A collection of values returned by getDeployment.
    """
    def __init__(__self__, alias=None, apms=None, deployment_template_id=None, elasticsearches=None, enterprise_searches=None, healthy=None, id=None, integrations_servers=None, kibanas=None, name=None, observabilities=None, region=None, tags=None, traffic_filters=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if apms and not isinstance(apms, list):
            raise TypeError("Expected argument 'apms' to be a list")
        pulumi.set(__self__, "apms", apms)
        if deployment_template_id and not isinstance(deployment_template_id, str):
            raise TypeError("Expected argument 'deployment_template_id' to be a str")
        pulumi.set(__self__, "deployment_template_id", deployment_template_id)
        if elasticsearches and not isinstance(elasticsearches, list):
            raise TypeError("Expected argument 'elasticsearches' to be a list")
        pulumi.set(__self__, "elasticsearches", elasticsearches)
        if enterprise_searches and not isinstance(enterprise_searches, list):
            raise TypeError("Expected argument 'enterprise_searches' to be a list")
        pulumi.set(__self__, "enterprise_searches", enterprise_searches)
        if healthy and not isinstance(healthy, bool):
            raise TypeError("Expected argument 'healthy' to be a bool")
        pulumi.set(__self__, "healthy", healthy)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integrations_servers and not isinstance(integrations_servers, list):
            raise TypeError("Expected argument 'integrations_servers' to be a list")
        pulumi.set(__self__, "integrations_servers", integrations_servers)
        if kibanas and not isinstance(kibanas, list):
            raise TypeError("Expected argument 'kibanas' to be a list")
        pulumi.set(__self__, "kibanas", kibanas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if observabilities and not isinstance(observabilities, list):
            raise TypeError("Expected argument 'observabilities' to be a list")
        pulumi.set(__self__, "observabilities", observabilities)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if traffic_filters and not isinstance(traffic_filters, list):
            raise TypeError("Expected argument 'traffic_filters' to be a list")
        pulumi.set(__self__, "traffic_filters", traffic_filters)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        Deployment alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def apms(self) -> Sequence['outputs.GetDeploymentApmResult']:
        """
        Instance configuration of the APM type.
        """
        return pulumi.get(self, "apms")

    @property
    @pulumi.getter(name="deploymentTemplateId")
    def deployment_template_id(self) -> str:
        """
        ID of the deployment template this deployment is based off.
        """
        return pulumi.get(self, "deployment_template_id")

    @property
    @pulumi.getter
    def elasticsearches(self) -> Sequence['outputs.GetDeploymentElasticsearchResult']:
        """
        Instance configuration of the Elasticsearch Elasticsearch resource.
        """
        return pulumi.get(self, "elasticsearches")

    @property
    @pulumi.getter(name="enterpriseSearches")
    def enterprise_searches(self) -> Sequence['outputs.GetDeploymentEnterpriseSearchResult']:
        """
        Instance configuration of the Enterprise Search type.
        """
        return pulumi.get(self, "enterprise_searches")

    @property
    @pulumi.getter
    def healthy(self) -> bool:
        """
        Overall health status of the deployment.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique ID of the deployment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationsServers")
    def integrations_servers(self) -> Sequence['outputs.GetDeploymentIntegrationsServerResult']:
        """
        Instance configuration of the Integrations Server type.
        """
        return pulumi.get(self, "integrations_servers")

    @property
    @pulumi.getter
    def kibanas(self) -> Sequence['outputs.GetDeploymentKibanaResult']:
        """
        Instance configuration of the Kibana type.
        """
        return pulumi.get(self, "kibanas")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the deployment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def observabilities(self) -> Sequence['outputs.GetDeploymentObservabilityResult']:
        """
        Observability settings. Information about logs and metrics shipped to a dedicated deployment.
        """
        return pulumi.get(self, "observabilities")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region where the deployment is hosted.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key value map of arbitrary string tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficFilters")
    def traffic_filters(self) -> Sequence[str]:
        """
        Traffic filter block, which contains a list of traffic filter rule identifiers.
        """
        return pulumi.get(self, "traffic_filters")


class AwaitableGetDeploymentResult(GetDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentResult(
            alias=self.alias,
            apms=self.apms,
            deployment_template_id=self.deployment_template_id,
            elasticsearches=self.elasticsearches,
            enterprise_searches=self.enterprise_searches,
            healthy=self.healthy,
            id=self.id,
            integrations_servers=self.integrations_servers,
            kibanas=self.kibanas,
            name=self.name,
            observabilities=self.observabilities,
            region=self.region,
            tags=self.tags,
            traffic_filters=self.traffic_filters)


def get_deployment(id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentResult:
    """
    Use this data source to retrieve information about an existing Elastic Cloud deployment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_ec as ec

    example = ec.get_deployment(id="f759065e5e64e9f3546f6c44f2743893")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: The unique ID of the deployment.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ec:index/getDeployment:getDeployment', __args__, opts=opts, typ=GetDeploymentResult).value

    return AwaitableGetDeploymentResult(
        alias=pulumi.get(__ret__, 'alias'),
        apms=pulumi.get(__ret__, 'apms'),
        deployment_template_id=pulumi.get(__ret__, 'deployment_template_id'),
        elasticsearches=pulumi.get(__ret__, 'elasticsearches'),
        enterprise_searches=pulumi.get(__ret__, 'enterprise_searches'),
        healthy=pulumi.get(__ret__, 'healthy'),
        id=pulumi.get(__ret__, 'id'),
        integrations_servers=pulumi.get(__ret__, 'integrations_servers'),
        kibanas=pulumi.get(__ret__, 'kibanas'),
        name=pulumi.get(__ret__, 'name'),
        observabilities=pulumi.get(__ret__, 'observabilities'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        traffic_filters=pulumi.get(__ret__, 'traffic_filters'))


@_utilities.lift_output_func(get_deployment)
def get_deployment_output(id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeploymentResult]:
    """
    Use this data source to retrieve information about an existing Elastic Cloud deployment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_ec as ec

    example = ec.get_deployment(id="f759065e5e64e9f3546f6c44f2743893")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: The unique ID of the deployment.
    """
    ...
