import { IPolicyValidationPluginBeta1, IPolicyValidationContextBeta1, PolicyValidationPluginReportBeta1 } from 'aws-cdk-lib';
export interface CfnGuardValidatorProps {
    /**
     * Enable the default Control Tower Guard rules
     *
     * @default true
     */
    readonly controlTowerRulesEnabled?: boolean;
    /**
     * List of rule names to disable
     *
     * @default - no rules are disabled
     */
    readonly disabledRules?: string[];
    /**
     * Local file paths to either a directory containing
     * guard rules, or to an individual guard rule file
     *
     * If the path is to a directory then the directory must
     * only contain guard rule and the plugin will use
     * all the rules in the directory
     *
     * @default - no local rules will be used
     */
    readonly rules?: string[];
}
/**
 * A validation plugin using CFN Guard
 */
export declare class CfnGuardValidator implements IPolicyValidationPluginBeta1 {
    readonly name: string;
    readonly version?: string;
    readonly ruleIds?: string[];
    private readonly rulesPaths;
    private readonly guard;
    private readonly disabledRules;
    constructor(props?: CfnGuardValidatorProps);
    private getRuleIds;
    validate(context: IPolicyValidationContextBeta1): PolicyValidationPluginReportBeta1;
    /**
     * Get the rules to execute. We can return directories as long as none of the rules in the
     * directory have been disabled
     */
    private getRules;
    private execGuard;
}
