"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_element_1 = require("./cfn-element");
const util_1 = require("./util");
/**
 * The Rules that define template constraints in an AWS Service Catalog portfolio describe when
 * end users can use the template and which values they can specify for parameters that are declared
 * in the AWS CloudFormation template used to create the product they are attempting to use. Rules
 * are useful for preventing end users from inadvertently specifying an incorrect value.
 * For example, you can add a rule to verify whether end users specified a valid subnet in a
 * given VPC or used m1.small instance types for test environments. AWS CloudFormation uses
 * rules to validate parameter values before it creates the resources for the product.
 *
 * A rule can include a RuleCondition property and must include an Assertions property.
 * For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property.
 * You define a rule condition and assertions by using rule-specific intrinsic functions.
 *
 * @link https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 */
class CfnRule extends cfn_element_1.CfnRefElement {
    /**
     * Creates and adds a rule.
     * @param scope The parent construct.
     * @param props The rule props.
     */
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.ruleCondition = props && props.ruleCondition;
        this.assertions = props && props.assertions;
    }
    /**
     * Adds an assertion to the rule.
     * @param condition The expression to evaluation.
     * @param description The description of the assertion.
     */
    addAssertion(condition, description) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ICfnConditionExpression(condition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAssertion);
            }
            throw error;
        }
        if (!this.assertions) {
            this.assertions = [];
        }
        this.assertions.push({
            assert: condition,
            assertDescription: description,
        });
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Rules: {
                [this.logicalId]: {
                    RuleCondition: this.ruleCondition,
                    Assertions: util_1.capitalizePropertyNames(this, this.assertions),
                },
            },
        };
    }
}
exports.CfnRule = CfnRule;
_a = JSII_RTTI_SYMBOL_1;
CfnRule[_a] = { fqn: "@aws-cdk/core.CfnRule", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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