"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
/**
 * Base class for implementing an IStackSynthesizer
 *
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise @_internal to the framework
 * and could not be accessed by external implementors.
 */
class StackSynthesizer {
    /**
     * Have the stack write out its template
     */
    synthesizeStackTemplate(stack, session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesizeStackTemplate);
            }
            throw error;
        }
        stack._synthesizeTemplate(session);
    }
    /**
     * Write the stack artifact to the session
     *
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     */
    emitStackArtifact(stack, session, options = {}) {
        var _b;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
            jsiiDeprecationWarnings._aws_cdk_core_SynthesizeStackArtifactOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.emitStackArtifact);
            }
            throw error;
        }
        _shared_1.addStackArtifactToAssembly(session, stack, options !== null && options !== void 0 ? options : {}, (_b = options.additionalDependencies) !== null && _b !== void 0 ? _b : []);
    }
}
exports.StackSynthesizer = StackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
StackSynthesizer[_a] = { fqn: "@aws-cdk/core.StackSynthesizer", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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