"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .metadata import Metadata, MetadataTypedDict
from .mode import Mode
from .url import URL, URLTypedDict
from .url_nullable import URLNullable, URLNullableTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListCaptureResponseSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCaptureResponseSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCaptureResponseStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The capture's status."""

    PENDING = "pending"
    SUCCEEDED = "succeeded"
    FAILED = "failed"


class ListCaptureResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    shipment: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListCaptureResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    shipment: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement", "shipment"]
        nullable_fields = ["settlement", "shipment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCaptureResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    amount: Nullable[AmountNullableTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    status: ListCaptureResponseStatus
    payment_id: str
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ListCaptureResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    description: NotRequired[str]
    r"""The description of the capture."""
    settlement_amount: NotRequired[
        Nullable[ListCaptureResponseSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    shipment_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """


class ListCaptureResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    amount: Nullable[AmountNullable]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    status: Annotated[
        ListCaptureResponseStatus, PlainValidator(validate_open_enum(False))
    ]

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[ListCaptureResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    description: Optional[str] = None
    r"""The description of the capture."""

    settlement_amount: Annotated[
        OptionalNullable[ListCaptureResponseSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    shipment_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="shipmentId")
    ] = UNSET
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        nullable_fields = [
            "amount",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
