"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListPermissionsPermissionsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListPermissionsPermissionsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListPermissionsPermissionsLinksTypedDict(TypedDict):
    documentation: ListPermissionsPermissionsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListPermissionsPermissionsLinks(BaseModel):
    documentation: ListPermissionsPermissionsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListPermissionsPermissionsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListPermissionsPermissionsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class ListPermissionsPermissionsResponseBody(ClientError):
    r"""An error response object."""

    data: ListPermissionsPermissionsResponseBodyData

    def __init__(
        self,
        data: ListPermissionsPermissionsResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListPermissionsPermissionsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsPermissionsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsPermissionsResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsPermissionsResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsPermissionsResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListPermissionsPermissionsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListPermissionsPermissionsResponseDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsPermissionsResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListPermissionsPermissionsSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListPermissionsPermissionsResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsPermissionsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this permission. Example: `payments.read`."""
    description: NotRequired[str]
    r"""A short description of what kind of access the permission enables."""
    granted: NotRequired[bool]
    r"""Whether this permission is granted to the app by the organization."""
    links: NotRequired[ListPermissionsPermissionsResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListPermissionsPermissions(BaseModel):
    resource: Optional[str] = "permission"
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this permission. Example: `payments.read`."""

    description: Optional[str] = None
    r"""A short description of what kind of access the permission enables."""

    granted: Optional[bool] = None
    r"""Whether this permission is granted to the app by the organization."""

    links: Annotated[
        Optional[ListPermissionsPermissionsResponseLinks],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListPermissionsEmbeddedTypedDict(TypedDict):
    permissions: NotRequired[List[ListPermissionsPermissionsTypedDict]]
    r"""An array of permission objects."""


class ListPermissionsEmbedded(BaseModel):
    permissions: Optional[List[ListPermissionsPermissions]] = None
    r"""An array of permission objects."""


class ListPermissionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListPermissionsSelfTypedDict]
    r"""The URL to the current set of items."""
    documentation: NotRequired[ListPermissionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListPermissionsSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    documentation: Optional[ListPermissionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsResponseBodyTypedDict(TypedDict):
    r"""A list of permission objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListPermissionsEmbeddedTypedDict]
    links: NotRequired[ListPermissionsLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListPermissionsResponseBody(BaseModel):
    r"""A list of permission objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListPermissionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListPermissionsLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
