"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mollie import models, utils
from mollie._hooks import HookContext
from mollie.types import OptionalNullable, UNSET
from mollie.utils import get_security_from_env
from mollie.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Subscriptions(BaseSDK):
    def create(
        self,
        *,
        customer_id: str,
        amount: Union[
            models.CreateSubscriptionAmount, models.CreateSubscriptionAmountTypedDict
        ],
        interval: str,
        description: str,
        times: OptionalNullable[int] = UNSET,
        start_date: Optional[str] = None,
        method: OptionalNullable[str] = UNSET,
        application_fee: Optional[
            Union[
                models.CreateSubscriptionApplicationFee,
                models.CreateSubscriptionApplicationFeeTypedDict,
            ]
        ] = None,
        metadata: OptionalNullable[
            Union[
                models.CreateSubscriptionMetadata,
                models.CreateSubscriptionMetadataTypedDict,
            ]
        ] = UNSET,
        webhook_url: Optional[str] = None,
        mandate_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateSubscriptionResponseBody:
        r"""Create subscription

        With subscriptions, you can schedule recurring payments to take place at regular intervals.

        For example, by simply specifying an `amount` and an `interval`, you can create an endless subscription to charge a monthly fee, until you cancel the subscription.

        Or, you could use the times parameter to only charge a limited number of times, for example to split a big transaction in multiple parts.

        A few example usages:

        `amount[currency]=\"EUR\"` `amount[value]=\"5.00\"` `interval=\"2 weeks\"` Your customer will be charged €5 once every two weeks.

        `amount[currency]=\"EUR\"` `amount[value]=\"20.00\"` `interval=\"1 day\" times=5` Your customer will be charged €20 every day, for five consecutive days.

        `amount[currency]=\"EUR\"` `amount[value]=\"10.00\"` `interval=\"1 month\"` `startDate=\"2018-04-30\"` Your customer will be charged €10 on the last day of each month, starting in April 2018.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param amount: The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10.
        :param interval: Interval to wait between payments, for example `1 month` or `14 days`.  The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).  Possible values: `... days` `... weeks` `... months`
        :param description: The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.  **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
        :param times: Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.  Test mode subscriptions will get canceled automatically after 10 payments.
        :param start_date: The start date of the subscription in `YYYY-MM-DD` format.
        :param method: The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used.  Possible values: `creditcard` `directdebit` `paypal`
        :param application_fee: With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.  Setting an application fee on the subscription will ensure this fee is charged on each individual payment.  Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
        :param metadata: Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.  Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
        :param webhook_url: We will call this URL for any payment status changes of payments resulting from this subscription.  This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
        :param mandate_id: The mandate used for this subscription, if any.
        :param testmode: Whether to create the entity in test mode or live mode.  Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSubscriptionRequest(
            customer_id=customer_id,
            request_body=models.CreateSubscriptionRequestBody(
                amount=utils.get_pydantic_model(
                    amount, models.CreateSubscriptionAmount
                ),
                times=times,
                interval=interval,
                start_date=start_date,
                description=description,
                method=method,
                application_fee=utils.get_pydantic_model(
                    application_fee, Optional[models.CreateSubscriptionApplicationFee]
                ),
                metadata=utils.get_pydantic_model(
                    metadata, OptionalNullable[models.CreateSubscriptionMetadata]
                ),
                webhook_url=webhook_url,
                mandate_id=mandate_id,
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/customers/{customerId}/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return unmarshal_json_response(
                models.CreateSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.CreateSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.CreateSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        customer_id: str,
        amount: Union[
            models.CreateSubscriptionAmount, models.CreateSubscriptionAmountTypedDict
        ],
        interval: str,
        description: str,
        times: OptionalNullable[int] = UNSET,
        start_date: Optional[str] = None,
        method: OptionalNullable[str] = UNSET,
        application_fee: Optional[
            Union[
                models.CreateSubscriptionApplicationFee,
                models.CreateSubscriptionApplicationFeeTypedDict,
            ]
        ] = None,
        metadata: OptionalNullable[
            Union[
                models.CreateSubscriptionMetadata,
                models.CreateSubscriptionMetadataTypedDict,
            ]
        ] = UNSET,
        webhook_url: Optional[str] = None,
        mandate_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateSubscriptionResponseBody:
        r"""Create subscription

        With subscriptions, you can schedule recurring payments to take place at regular intervals.

        For example, by simply specifying an `amount` and an `interval`, you can create an endless subscription to charge a monthly fee, until you cancel the subscription.

        Or, you could use the times parameter to only charge a limited number of times, for example to split a big transaction in multiple parts.

        A few example usages:

        `amount[currency]=\"EUR\"` `amount[value]=\"5.00\"` `interval=\"2 weeks\"` Your customer will be charged €5 once every two weeks.

        `amount[currency]=\"EUR\"` `amount[value]=\"20.00\"` `interval=\"1 day\" times=5` Your customer will be charged €20 every day, for five consecutive days.

        `amount[currency]=\"EUR\"` `amount[value]=\"10.00\"` `interval=\"1 month\"` `startDate=\"2018-04-30\"` Your customer will be charged €10 on the last day of each month, starting in April 2018.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param amount: The amount for each individual payment that is charged with this subscription. For example, for a monthly subscription of €10, the subscription amount should be set to €10.
        :param interval: Interval to wait between payments, for example `1 month` or `14 days`.  The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).  Possible values: `... days` `... weeks` `... months`
        :param description: The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.  **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
        :param times: Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.  Test mode subscriptions will get canceled automatically after 10 payments.
        :param start_date: The start date of the subscription in `YYYY-MM-DD` format.
        :param method: The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used.  Possible values: `creditcard` `directdebit` `paypal`
        :param application_fee: With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.  Setting an application fee on the subscription will ensure this fee is charged on each individual payment.  Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more information.
        :param metadata: Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.  Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
        :param webhook_url: We will call this URL for any payment status changes of payments resulting from this subscription.  This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
        :param mandate_id: The mandate used for this subscription, if any.
        :param testmode: Whether to create the entity in test mode or live mode.  Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSubscriptionRequest(
            customer_id=customer_id,
            request_body=models.CreateSubscriptionRequestBody(
                amount=utils.get_pydantic_model(
                    amount, models.CreateSubscriptionAmount
                ),
                times=times,
                interval=interval,
                start_date=start_date,
                description=description,
                method=method,
                application_fee=utils.get_pydantic_model(
                    application_fee, Optional[models.CreateSubscriptionApplicationFee]
                ),
                metadata=utils.get_pydantic_model(
                    metadata, OptionalNullable[models.CreateSubscriptionMetadata]
                ),
                webhook_url=webhook_url,
                mandate_id=mandate_id,
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/customers/{customerId}/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return unmarshal_json_response(
                models.CreateSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.CreateSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.CreateSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def list(
        self,
        *,
        customer_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListSubscriptionsResponseBody:
        r"""List customer subscriptions

        Retrieve all subscriptions of a customer.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSubscriptionsRequest(
            customer_id=customer_id,
            from_=from_,
            limit=limit,
            sort=sort,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/customers/{customerId}/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-subscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListSubscriptionsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListSubscriptionsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionsSubscriptionsResponseResponseBodyData, http_res
            )
            raise models.ListSubscriptionsSubscriptionsResponseResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        customer_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListSubscriptionsResponseBody:
        r"""List customer subscriptions

        Retrieve all subscriptions of a customer.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSubscriptionsRequest(
            customer_id=customer_id,
            from_=from_,
            limit=limit,
            sort=sort,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/customers/{customerId}/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-subscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListSubscriptionsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListSubscriptionsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionsSubscriptionsResponseResponseBodyData, http_res
            )
            raise models.ListSubscriptionsSubscriptionsResponseResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def get(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetSubscriptionResponseBody:
        r"""Get subscription

        Retrieve a single subscription by its ID and the ID of its parent customer.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(models.GetSubscriptionResponseBody, http_res)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.GetSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.GetSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetSubscriptionResponseBody:
        r"""Get subscription

        Retrieve a single subscription by its ID and the ID of its parent customer.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(models.GetSubscriptionResponseBody, http_res)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.GetSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.GetSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def update(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        amount: Optional[
            Union[
                models.UpdateSubscriptionAmount,
                models.UpdateSubscriptionAmountTypedDict,
            ]
        ] = None,
        description: Optional[str] = None,
        interval: Optional[str] = None,
        start_date: Optional[str] = None,
        times: Optional[int] = None,
        metadata: OptionalNullable[
            Union[
                models.UpdateSubscriptionMetadata,
                models.UpdateSubscriptionMetadataTypedDict,
            ]
        ] = UNSET,
        webhook_url: Optional[str] = None,
        mandate_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UpdateSubscriptionResponseBody:
        r"""Update subscription

        Update an existing subscription.

        Canceled subscriptions cannot be updated.

        For an in-depth explanation of each parameter, refer to the [Create subscription](create-subscription) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param amount: Update the amount for future payments of this subscription.
        :param description: The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.  **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
        :param interval: Interval to wait between payments, for example `1 month` or `14 days`.  The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).  Possible values: `... days` `... weeks` `... months`
        :param start_date: The start date of the subscription in `YYYY-MM-DD` format.
        :param times: Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.  Test mode subscriptions will get canceled automatically after 10 payments.
        :param metadata: Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.  Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
        :param webhook_url: We will call this URL for any payment status changes of payments resulting from this subscription.  This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
        :param mandate_id: The mandate used for this subscription, if any.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            request_body=models.UpdateSubscriptionRequestBody(
                amount=utils.get_pydantic_model(
                    amount, Optional[models.UpdateSubscriptionAmount]
                ),
                description=description,
                interval=interval,
                start_date=start_date,
                times=times,
                metadata=utils.get_pydantic_model(
                    metadata, OptionalNullable[models.UpdateSubscriptionMetadata]
                ),
                webhook_url=webhook_url,
                mandate_id=mandate_id,
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.UpdateSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.UpdateSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.UpdateSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        amount: Optional[
            Union[
                models.UpdateSubscriptionAmount,
                models.UpdateSubscriptionAmountTypedDict,
            ]
        ] = None,
        description: Optional[str] = None,
        interval: Optional[str] = None,
        start_date: Optional[str] = None,
        times: Optional[int] = None,
        metadata: OptionalNullable[
            Union[
                models.UpdateSubscriptionMetadata,
                models.UpdateSubscriptionMetadataTypedDict,
            ]
        ] = UNSET,
        webhook_url: Optional[str] = None,
        mandate_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UpdateSubscriptionResponseBody:
        r"""Update subscription

        Update an existing subscription.

        Canceled subscriptions cannot be updated.

        For an in-depth explanation of each parameter, refer to the [Create subscription](create-subscription) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param amount: Update the amount for future payments of this subscription.
        :param description: The subscription's description will be used as the description of the resulting individual payments and so showing up on the bank statement of the consumer.  **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
        :param interval: Interval to wait between payments, for example `1 month` or `14 days`.  The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).  Possible values: `... days` `... weeks` `... months`
        :param start_date: The start date of the subscription in `YYYY-MM-DD` format.
        :param times: Total number of payments for the subscription. Once this number of payments is reached, the subscription is considered completed.  Test mode subscriptions will get canceled automatically after 10 payments.
        :param metadata: Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.  Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
        :param webhook_url: We will call this URL for any payment status changes of payments resulting from this subscription.  This webhook will receive **all** events for the subscription's payments. This may include payment failures as well. Be sure to verify the payment's subscription ID and its status.
        :param mandate_id: The mandate used for this subscription, if any.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            request_body=models.UpdateSubscriptionRequestBody(
                amount=utils.get_pydantic_model(
                    amount, Optional[models.UpdateSubscriptionAmount]
                ),
                description=description,
                interval=interval,
                start_date=start_date,
                times=times,
                metadata=utils.get_pydantic_model(
                    metadata, OptionalNullable[models.UpdateSubscriptionMetadata]
                ),
                webhook_url=webhook_url,
                mandate_id=mandate_id,
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.UpdateSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.UpdateSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.UpdateSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def cancel(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CancelSubscriptionResponseBody:
        r"""Cancel subscription

        Cancel an existing subscription. Canceling a subscription has no effect on the mandates of the customer.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            request_body=models.CancelSubscriptionRequestBody(
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="DELETE",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CancelSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="cancel-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.CancelSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.CancelSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.CancelSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def cancel_async(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CancelSubscriptionResponseBody:
        r"""Cancel subscription

        Cancel an existing subscription. Canceling a subscription has no effect on the mandates of the customer.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelSubscriptionRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            request_body=models.CancelSubscriptionRequestBody(
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="DELETE",
            path="/customers/{customerId}/subscriptions/{subscriptionId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CancelSubscriptionRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="cancel-subscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.CancelSubscriptionResponseBody, http_res
            )
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.CancelSubscriptionSubscriptionsResponseBodyData, http_res
            )
            raise models.CancelSubscriptionSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def all(
        self,
        *,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListAllSubscriptionsResponseBody:
        r"""List all subscriptions

        Retrieve all subscriptions initiated across all your customers.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the resources for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllSubscriptionsRequest(
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-all-subscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListAllSubscriptionsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListAllSubscriptionsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListAllSubscriptionsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def all_async(
        self,
        *,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListAllSubscriptionsResponseBody:
        r"""List all subscriptions

        Retrieve all subscriptions initiated across all your customers.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read**](/reference/authentication)

        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the resources for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllSubscriptionsRequest(
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-all-subscriptions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListAllSubscriptionsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListAllSubscriptionsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListAllSubscriptionsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    def list_payments(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListSubscriptionPaymentsResponseBody:
        r"""List subscription payments

        Retrieve all payments of a specific subscription.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read** **payments.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the resources for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSubscriptionPaymentsRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/customers/{customerId}/subscriptions/{subscriptionId}/payments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-subscription-payments",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListSubscriptionPaymentsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionPaymentsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListSubscriptionPaymentsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def list_payments_async(
        self,
        *,
        customer_id: str,
        subscription_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: Optional[str] = None,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListSubscriptionPaymentsResponseBody:
        r"""List subscription payments

        Retrieve all payments of a specific subscription.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **subscriptions.read** **payments.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param subscription_id: Provide the ID of the related subscription.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve the resources for.  Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSubscriptionPaymentsRequest(
            customer_id=customer_id,
            subscription_id=subscription_id,
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/customers/{customerId}/subscriptions/{subscriptionId}/payments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list-subscription-payments",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return unmarshal_json_response(
                models.ListSubscriptionPaymentsResponseBody, http_res
            )
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = unmarshal_json_response(
                models.ListSubscriptionPaymentsSubscriptionsResponseBodyData, http_res
            )
            raise models.ListSubscriptionPaymentsSubscriptionsResponseBody(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)
