from abc import ABC, abstractmethod
from sphere.core.schemas.buildings import Buildings


class AbstractVulnerabilityFunction(ABC):    
    @abstractmethod
    def calculate_vulnerability(self):
        """
        Calculate vulnerability percentages for buildings.
        
        This is the main method that should be implemented by concrete classes.
        It should populate damage percentage fields in the buildings data.
        """
        pass
    
    @abstractmethod
    def apply_damage_percentages(self):
        """
        Apply damage percentages to buildings based on calculated vulnerability.
        
        This method should be called after calculate_vulnerability() to
        populate the final damage percentage fields.
        """
        pass