# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceDictionaryItemsArgs', 'ServiceDictionaryItems']

@pulumi.input_type
class ServiceDictionaryItemsArgs:
    def __init__(__self__, *,
                 dictionary_id: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_items: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ServiceDictionaryItems resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        ServiceDictionaryItemsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dictionary_id=dictionary_id,
            service_id=service_id,
            items=items,
            manage_items=manage_items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dictionary_id: pulumi.Input[str],
             service_id: pulumi.Input[str],
             items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             manage_items: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("dictionary_id", dictionary_id)
        _setter("service_id", service_id)
        if items is not None:
            _setter("items", items)
        if manage_items is not None:
            _setter("manage_items", manage_items)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Input[str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @manage_items.setter
    def manage_items(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_items", value)


@pulumi.input_type
class _ServiceDictionaryItemsState:
    def __init__(__self__, *,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_items: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceDictionaryItems resources.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        _ServiceDictionaryItemsState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dictionary_id=dictionary_id,
            items=items,
            manage_items=manage_items,
            service_id=service_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dictionary_id: Optional[pulumi.Input[str]] = None,
             items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             manage_items: Optional[pulumi.Input[bool]] = None,
             service_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if dictionary_id is not None:
            _setter("dictionary_id", dictionary_id)
        if items is not None:
            _setter("items", items)
        if manage_items is not None:
            _setter("manage_items", manage_items)
        if service_id is not None:
            _setter("service_id", service_id)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @manage_items.setter
    def manage_items(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_items", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)


class ServiceDictionaryItems(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_items: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items.items` The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDictionaryItems:ServiceDictionaryItems items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

         If Terraform is already managing remote dictionary items against a resource being imported then the user will be asked to remove it from the existing Terraform state. The following is an example of the Terraform state command to remove the resource named `fastly_service_dictionary_items.items` from the Terraform state file. $ terraform state rm fastly_service_dictionary_items.items

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDictionaryItemsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items.items` The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDictionaryItems:ServiceDictionaryItems items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

         If Terraform is already managing remote dictionary items against a resource being imported then the user will be asked to remove it from the existing Terraform state. The following is an example of the Terraform state command to remove the resource named `fastly_service_dictionary_items.items` from the Terraform state file. $ terraform state rm fastly_service_dictionary_items.items

        :param str resource_name: The name of the resource.
        :param ServiceDictionaryItemsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDictionaryItemsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ServiceDictionaryItemsArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manage_items: Optional[pulumi.Input[bool]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDictionaryItemsArgs.__new__(ServiceDictionaryItemsArgs)

            if dictionary_id is None and not opts.urn:
                raise TypeError("Missing required property 'dictionary_id'")
            __props__.__dict__["dictionary_id"] = dictionary_id
            __props__.__dict__["items"] = items
            __props__.__dict__["manage_items"] = manage_items
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceDictionaryItems, __self__).__init__(
            'fastly:index/serviceDictionaryItems:ServiceDictionaryItems',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dictionary_id: Optional[pulumi.Input[str]] = None,
            items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            manage_items: Optional[pulumi.Input[bool]] = None,
            service_id: Optional[pulumi.Input[str]] = None) -> 'ServiceDictionaryItems':
        """
        Get an existing ServiceDictionaryItems resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDictionaryItemsState.__new__(_ServiceDictionaryItemsState)

        __props__.__dict__["dictionary_id"] = dictionary_id
        __props__.__dict__["items"] = items
        __props__.__dict__["manage_items"] = manage_items
        __props__.__dict__["service_id"] = service_id
        return ServiceDictionaryItems(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Output[str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

