"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const common_1 = require("./common");
const helpers_1 = require("./private/helpers");
/**
 * An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 */
class S3Bucket {
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kinesisfirehose_destinations_S3BucketProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3Bucket);
            }
            throw error;
        }
        if (this.props.s3Backup?.mode === common_1.BackupMode.FAILED) {
            throw new Error('S3 destinations do not support BackupMode.FAILED');
        }
    }
    bind(scope, _options) {
        const role = this.props.role ?? new iam.Role(scope, 'S3 Destination Role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        const bucketGrant = this.bucket.grantReadWrite(role);
        const { loggingOptions, dependables: loggingDependables } = helpers_1.createLoggingOptions(scope, {
            logging: this.props.logging,
            logGroup: this.props.logGroup,
            role,
            streamId: 'S3Destination',
        }) ?? {};
        const { backupConfig, dependables: backupDependables } = helpers_1.createBackupConfig(scope, role, this.props.s3Backup) ?? {};
        return {
            extendedS3DestinationConfiguration: {
                cloudWatchLoggingOptions: loggingOptions,
                processingConfiguration: helpers_1.createProcessingConfig(scope, role, this.props.processor),
                roleArn: role.roleArn,
                s3BackupConfiguration: backupConfig,
                s3BackupMode: this.getS3BackupMode(),
                bufferingHints: helpers_1.createBufferingHints(this.props.bufferingInterval, this.props.bufferingSize),
                bucketArn: this.bucket.bucketArn,
                compressionFormat: this.props.compression?.value,
                encryptionConfiguration: helpers_1.createEncryptionConfig(role, this.props.encryptionKey),
                errorOutputPrefix: this.props.errorOutputPrefix,
                prefix: this.props.dataOutputPrefix,
            },
            dependables: [bucketGrant, ...(loggingDependables ?? []), ...(backupDependables ?? [])],
        };
    }
    getS3BackupMode() {
        return this.props.s3Backup?.bucket || this.props.s3Backup?.mode === common_1.BackupMode.ALL
            ? 'Enabled'
            : undefined;
    }
}
exports.S3Bucket = S3Bucket;
_a = JSII_RTTI_SYMBOL_1;
S3Bucket[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations.S3Bucket", version: "1.184.0" };
//# sourceMappingURL=data:application/json;base64,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