"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
async function handler(event) {
    console.log('Event: %j', event);
    const sesNotification = event.Records[0].ses;
    if (!process.env.SOURCE_WHITELIST) {
        console.log('Missing SOURCE_WHITELIST');
        return { disposition: 'STOP_RULE' };
    }
    if (!new RegExp(process.env.SOURCE_WHITELIST).test(sesNotification.mail.source)) {
        console.log(`${sesNotification.mail.source} does not match /${process.env.SOURCE_WHITELIST}/`);
        return { disposition: 'STOP_RULE' };
    }
    return { disposition: 'CONTINUE' };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2hpdGVsaXN0LmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9lbWFpbC1yZWNlaXZlci93aGl0ZWxpc3QubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUErQjtBQUN4QixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXlCO0lBQ3JELE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRWhDLE1BQU0sZUFBZSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO0lBRTdDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDbEMsT0FBTyxDQUFDLEdBQUcsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFFLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQUksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixDQUFDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNoRixPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLG9CQUFvQixPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixHQUFHLENBQUMsQ0FBQztRQUMvRixPQUFPLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxDQUFDO0lBQ3RDLENBQUM7SUFFRCxPQUFPLEVBQUUsV0FBVyxFQUFFLFVBQVUsRUFBRSxDQUFDO0FBQ3JDLENBQUM7QUFoQkQsMEJBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50LWRpc2FibGUgbm8tY29uc29sZSAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5TRVNFdmVudCk6IFByb21pc2U8eyBkaXNwb3NpdGlvbjogc3RyaW5nIH0+IHtcbiAgY29uc29sZS5sb2coJ0V2ZW50OiAlaicsIGV2ZW50KTtcblxuICBjb25zdCBzZXNOb3RpZmljYXRpb24gPSBldmVudC5SZWNvcmRzWzBdLnNlcztcblxuICBpZiAoIXByb2Nlc3MuZW52LlNPVVJDRV9XSElURUxJU1QpIHtcbiAgICBjb25zb2xlLmxvZygnTWlzc2luZyBTT1VSQ0VfV0hJVEVMSVNUJyk7XG4gICAgcmV0dXJuIHsgZGlzcG9zaXRpb246ICdTVE9QX1JVTEUnIH07XG4gIH1cblxuICBpZiAoIW5ldyBSZWdFeHAocHJvY2Vzcy5lbnYuU09VUkNFX1dISVRFTElTVCkudGVzdChzZXNOb3RpZmljYXRpb24ubWFpbC5zb3VyY2UpKSB7XG4gICAgY29uc29sZS5sb2coYCR7c2VzTm90aWZpY2F0aW9uLm1haWwuc291cmNlfSBkb2VzIG5vdCBtYXRjaCAvJHtwcm9jZXNzLmVudi5TT1VSQ0VfV0hJVEVMSVNUfS9gKTtcbiAgICByZXR1cm4geyBkaXNwb3NpdGlvbjogJ1NUT1BfUlVMRScgfTtcbiAgfVxuXG4gIHJldHVybiB7IGRpc3Bvc2l0aW9uOiAnQ09OVElOVUUnIH07XG59XG4iXX0=