"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const client_eventbridge_1 = require("@aws-sdk/client-eventbridge");
const signature_1 = require("./signature");
const eventBridgeClient = new client_eventbridge_1.EventBridgeClient({});
/**
 * Handle Slack events
 */
async function handler(event) {
    console.log('Event: %j', event);
    // Base API gateway response
    const response = {
        statusCode: 200,
        body: '',
    };
    try {
        if (!process.env.SLACK_SIGNING_SECRET)
            throw new Error('The environment variable SLACK_SIGNING_SECRET is not defined');
        if (!event.body)
            throw new Error('Missing body');
        if (!event.headers['X-Slack-Signature'])
            throw new Error('Missing X-Slack-Signature');
        if (!event.headers['X-Slack-Request-Timestamp'])
            throw new Error('Missing X-Slack-Request-Timestamp');
        if (!(0, signature_1.verifyRequestSignature)({
            body: event.body,
            requestSignature: event.headers['X-Slack-Signature'],
            requestTimestamp: parseInt(event.headers['X-Slack-Request-Timestamp'], 10),
            signingSecret: process.env.SLACK_SIGNING_SECRET,
        })) {
            response.statusCode = 403;
            return response;
        }
        const body = JSON.parse(event.body);
        console.log('Body: %j', body);
        if (body.type === 'url_verification') { // Slack URL verification, respond with challenge
            console.log('URL verification');
            response.body = JSON.stringify({ challenge: body.challenge });
            return response;
        }
        const putEvents = await eventBridgeClient.send(new client_eventbridge_1.PutEventsCommand({
            Entries: [{
                    Detail: event.body,
                    DetailType: 'Slack Event',
                    Source: 'slack',
                    Resources: [body.api_app_id],
                    EventBusName: process.env.EVENT_BUS_NAME,
                    Time: new Date(body.event_time),
                }],
        }));
        console.log('Put events: %j', putEvents);
        return response;
    }
    catch (err) {
        console.log(err);
        response.statusCode = 500;
        return response;
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRzLmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zbGFjay1ldmVudHMvZXZlbnRzLmxhbWJkYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrQkFBK0I7QUFDL0Isb0VBQWtGO0FBQ2xGLDJDQUFxRDtBQUVyRCxNQUFNLGlCQUFpQixHQUFHLElBQUksc0NBQWlCLENBQUMsRUFBRSxDQUFDLENBQUM7QUFFcEQ7O0dBRUc7QUFDSSxLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXFDO0lBQ2pFLE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRWhDLDRCQUE0QjtJQUM1QixNQUFNLFFBQVEsR0FBb0M7UUFDaEQsVUFBVSxFQUFFLEdBQUc7UUFDZixJQUFJLEVBQUUsRUFBRTtLQUNULENBQUM7SUFFRixJQUFJLENBQUM7UUFDSCxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0I7WUFBRSxNQUFNLElBQUksS0FBSyxDQUFDLDhEQUE4RCxDQUFDLENBQUM7UUFFdkgsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJO1lBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUVqRCxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQztZQUFFLE1BQU0sSUFBSSxLQUFLLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUV0RixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQywyQkFBMkIsQ0FBQztZQUFFLE1BQU0sSUFBSSxLQUFLLENBQUMsbUNBQW1DLENBQUMsQ0FBQztRQUV0RyxJQUFJLENBQUMsSUFBQSxrQ0FBc0IsRUFBQztZQUMxQixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQztZQUNwRCxnQkFBZ0IsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQywyQkFBMkIsQ0FBQyxFQUFFLEVBQUUsQ0FBQztZQUMxRSxhQUFhLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0I7U0FDaEQsQ0FBQyxFQUFFLENBQUM7WUFDSCxRQUFRLENBQUMsVUFBVSxHQUFHLEdBQUcsQ0FBQztZQUMxQixPQUFPLFFBQVEsQ0FBQztRQUNsQixDQUFDO1FBRUQsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDcEMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFOUIsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLGtCQUFrQixFQUFFLENBQUMsQ0FBQyxpREFBaUQ7WUFDdkYsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1lBQ2hDLFFBQVEsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQztZQUM5RCxPQUFPLFFBQVEsQ0FBQztRQUNsQixDQUFDO1FBRUQsTUFBTSxTQUFTLEdBQUcsTUFBTSxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxxQ0FBZ0IsQ0FBQztZQUNsRSxPQUFPLEVBQUUsQ0FBQztvQkFDUixNQUFNLEVBQUUsS0FBSyxDQUFDLElBQUk7b0JBQ2xCLFVBQVUsRUFBRSxhQUFhO29CQUN6QixNQUFNLEVBQUUsT0FBTztvQkFDZixTQUFTLEVBQUUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO29CQUM1QixZQUFZLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxjQUFjO29CQUN4QyxJQUFJLEVBQUUsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztpQkFDaEMsQ0FBQztTQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0osT0FBTyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUV6QyxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztRQUNiLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDakIsUUFBUSxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUM7UUFDMUIsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQztBQUNILENBQUM7QUF2REQsMEJBdURDIiwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50LWRpc2FibGUgbm8tY29uc29sZSAqL1xuaW1wb3J0IHsgRXZlbnRCcmlkZ2VDbGllbnQsIFB1dEV2ZW50c0NvbW1hbmQgfSBmcm9tICdAYXdzLXNkay9jbGllbnQtZXZlbnRicmlkZ2UnO1xuaW1wb3J0IHsgdmVyaWZ5UmVxdWVzdFNpZ25hdHVyZSB9IGZyb20gJy4vc2lnbmF0dXJlJztcblxuY29uc3QgZXZlbnRCcmlkZ2VDbGllbnQgPSBuZXcgRXZlbnRCcmlkZ2VDbGllbnQoe30pO1xuXG4vKipcbiAqIEhhbmRsZSBTbGFjayBldmVudHNcbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5BUElHYXRld2F5UHJveHlFdmVudCk6IFByb21pc2U8QVdTTGFtYmRhLkFQSUdhdGV3YXlQcm94eVJlc3VsdD4ge1xuICBjb25zb2xlLmxvZygnRXZlbnQ6ICVqJywgZXZlbnQpO1xuXG4gIC8vIEJhc2UgQVBJIGdhdGV3YXkgcmVzcG9uc2VcbiAgY29uc3QgcmVzcG9uc2U6IEFXU0xhbWJkYS5BUElHYXRld2F5UHJveHlSZXN1bHQgPSB7XG4gICAgc3RhdHVzQ29kZTogMjAwLFxuICAgIGJvZHk6ICcnLFxuICB9O1xuXG4gIHRyeSB7XG4gICAgaWYgKCFwcm9jZXNzLmVudi5TTEFDS19TSUdOSU5HX1NFQ1JFVCkgdGhyb3cgbmV3IEVycm9yKCdUaGUgZW52aXJvbm1lbnQgdmFyaWFibGUgU0xBQ0tfU0lHTklOR19TRUNSRVQgaXMgbm90IGRlZmluZWQnKTtcblxuICAgIGlmICghZXZlbnQuYm9keSkgdGhyb3cgbmV3IEVycm9yKCdNaXNzaW5nIGJvZHknKTtcblxuICAgIGlmICghZXZlbnQuaGVhZGVyc1snWC1TbGFjay1TaWduYXR1cmUnXSkgdGhyb3cgbmV3IEVycm9yKCdNaXNzaW5nIFgtU2xhY2stU2lnbmF0dXJlJyk7XG5cbiAgICBpZiAoIWV2ZW50LmhlYWRlcnNbJ1gtU2xhY2stUmVxdWVzdC1UaW1lc3RhbXAnXSkgdGhyb3cgbmV3IEVycm9yKCdNaXNzaW5nIFgtU2xhY2stUmVxdWVzdC1UaW1lc3RhbXAnKTtcblxuICAgIGlmICghdmVyaWZ5UmVxdWVzdFNpZ25hdHVyZSh7XG4gICAgICBib2R5OiBldmVudC5ib2R5LFxuICAgICAgcmVxdWVzdFNpZ25hdHVyZTogZXZlbnQuaGVhZGVyc1snWC1TbGFjay1TaWduYXR1cmUnXSxcbiAgICAgIHJlcXVlc3RUaW1lc3RhbXA6IHBhcnNlSW50KGV2ZW50LmhlYWRlcnNbJ1gtU2xhY2stUmVxdWVzdC1UaW1lc3RhbXAnXSwgMTApLFxuICAgICAgc2lnbmluZ1NlY3JldDogcHJvY2Vzcy5lbnYuU0xBQ0tfU0lHTklOR19TRUNSRVQsXG4gICAgfSkpIHtcbiAgICAgIHJlc3BvbnNlLnN0YXR1c0NvZGUgPSA0MDM7XG4gICAgICByZXR1cm4gcmVzcG9uc2U7XG4gICAgfVxuXG4gICAgY29uc3QgYm9keSA9IEpTT04ucGFyc2UoZXZlbnQuYm9keSk7XG4gICAgY29uc29sZS5sb2coJ0JvZHk6ICVqJywgYm9keSk7XG5cbiAgICBpZiAoYm9keS50eXBlID09PSAndXJsX3ZlcmlmaWNhdGlvbicpIHsgLy8gU2xhY2sgVVJMIHZlcmlmaWNhdGlvbiwgcmVzcG9uZCB3aXRoIGNoYWxsZW5nZVxuICAgICAgY29uc29sZS5sb2coJ1VSTCB2ZXJpZmljYXRpb24nKTtcbiAgICAgIHJlc3BvbnNlLmJvZHkgPSBKU09OLnN0cmluZ2lmeSh7IGNoYWxsZW5nZTogYm9keS5jaGFsbGVuZ2UgfSk7XG4gICAgICByZXR1cm4gcmVzcG9uc2U7XG4gICAgfVxuXG4gICAgY29uc3QgcHV0RXZlbnRzID0gYXdhaXQgZXZlbnRCcmlkZ2VDbGllbnQuc2VuZChuZXcgUHV0RXZlbnRzQ29tbWFuZCh7XG4gICAgICBFbnRyaWVzOiBbe1xuICAgICAgICBEZXRhaWw6IGV2ZW50LmJvZHksXG4gICAgICAgIERldGFpbFR5cGU6ICdTbGFjayBFdmVudCcsXG4gICAgICAgIFNvdXJjZTogJ3NsYWNrJyxcbiAgICAgICAgUmVzb3VyY2VzOiBbYm9keS5hcGlfYXBwX2lkXSxcbiAgICAgICAgRXZlbnRCdXNOYW1lOiBwcm9jZXNzLmVudi5FVkVOVF9CVVNfTkFNRSxcbiAgICAgICAgVGltZTogbmV3IERhdGUoYm9keS5ldmVudF90aW1lKSxcbiAgICAgIH1dLFxuICAgIH0pKTtcbiAgICBjb25zb2xlLmxvZygnUHV0IGV2ZW50czogJWonLCBwdXRFdmVudHMpO1xuXG4gICAgcmV0dXJuIHJlc3BvbnNlO1xuICB9IGNhdGNoIChlcnIpIHtcbiAgICBjb25zb2xlLmxvZyhlcnIpO1xuICAgIHJlc3BvbnNlLnN0YXR1c0NvZGUgPSA1MDA7XG4gICAgcmV0dXJuIHJlc3BvbnNlO1xuICB9XG59XG4iXX0=