"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyRequestSignature = void 0;
const crypto = require("crypto");
function verifyRequestSignature(options) {
    const fiveMinutesAgo = Math.floor(Date.now() / 1000) - (60 * 5);
    if (options.requestTimestamp < fiveMinutesAgo) {
        console.error('Slack request signing verification outdated');
        return false;
    }
    const hmac = crypto.createHmac('sha256', options.signingSecret);
    const [version, hash] = options.requestSignature.split('=');
    hmac.update(`${version}:${options.requestTimestamp}:${options.body}`);
    const hex = hmac.digest('hex');
    if (hash.length !== hex.length ||
        !crypto.timingSafeEqual(Buffer.from(hash), Buffer.from(hex))) {
        console.error('Slack request signing verification failed');
        return false;
    }
    return true;
}
exports.verifyRequestSignature = verifyRequestSignature;
//# sourceMappingURL=data:application/json;base64,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