"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const client_textract_1 = require("@aws-sdk/client-textract");
const web_api_1 = require("@slack/web-api");
const got_1 = require("got");
const textractClient = new client_textract_1.TextractClient({});
async function handler(event) {
    console.log('Event: %j', event);
    const slackClient = new web_api_1.WebClient(process.env.SLACK_TOKEN);
    // Get file info
    const info = await slackClient.files.info({
        file: event.file_id,
    });
    console.log('File info: %j', info);
    if (!info.file.mimetype.startsWith('image')) {
        console.log('Not an image');
        return;
    }
    // Get file
    const file = await (0, got_1.default)(info.file.url_private, {
        headers: {
            Authorization: `Bearer ${process.env.SLACK_TOKEN}`,
        },
    }).buffer();
    // Detect text with Textract
    const data = await textractClient.send(new client_textract_1.DetectDocumentTextCommand({
        Document: { Bytes: file },
    }));
    if (!data.Blocks) {
        console.log('No text detected');
        return;
    }
    // Add detected text in image thread
    const postMessage = await slackClient.chat.postMessage({
        channel: event.channel_id,
        text: data.Blocks.filter((b) => b.BlockType === 'LINE').map((b) => b.Text).join('\n'),
        thread_ts: info.file.shares.public[event.channel_id][0].ts,
    });
    console.log('Post message: %j', postMessage);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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