"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_ecr_1 = require("@aws-sdk/client-ecr");
const ecrClient = new client_ecr_1.ECRClient({});
async function handler(assetHashes) {
    if (!process.env.REPOSITORY_NAME) {
        throw new Error('Missing REPOSITORY_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await ecrClient.send(new client_ecr_1.DescribeImagesCommand({
            repositoryName: process.env.REPOSITORY_NAME,
            nextToken,
        }));
        const toDelete = response.imageDetails?.filter(x => {
            if (!x.imageTags) {
                return false;
            }
            let pred = !assetHashes.includes(x.imageTags[0]);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!x.imagePushedAt) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await ecrClient.send(new client_ecr_1.BatchDeleteImageCommand({
                    repositoryName: process.env.REPOSITORY_NAME,
                    imageIds: toDelete.map(x => ({ imageTag: x.imageTags[0] })),
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.imageSizeInBytes ?? 0), 0);
        }
        nextToken = response.nextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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