"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const path = require("path");
const client_s3_1 = require("@aws-sdk/client-s3");
const s3Client = new client_s3_1.S3Client({});
async function handler(assetHashes) {
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextKeyMarker;
    let finished = false;
    while (!finished) {
        const response = await s3Client.send(new client_s3_1.ListObjectVersionsCommand({
            Bucket: process.env.BUCKET_NAME,
            KeyMarker: nextKeyMarker,
        }));
        const toDelete = response.Versions?.filter(v => {
            if (!v.Key) {
                return false;
            }
            const hash = path.basename(v.Key, path.extname(v.Key));
            let pred = !assetHashes.includes(hash);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!v.LastModified) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && v.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3Client.send(new client_s3_1.DeleteObjectsCommand({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(v => ({ Key: v.Key, VersionId: v.VersionId })),
                    },
                }));
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
        }
        nextKeyMarker = response.NextKeyMarker;
        if (nextKeyMarker === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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