"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const cloudFormationClient = new client_cloudformation_1.CloudFormationClient({});
async function handler(stackName) {
    const template = await cloudFormationClient.send(new client_cloudformation_1.GetTemplateCommand({
        StackName: stackName,
    }));
    if (!template.TemplateBody) {
        return [];
    }
    if (!process.env.DOCKER_IMAGE_ASSET_HASH) {
        throw new Error('Missing DOCKER_IMAGE_ASSET_HASH environment variable');
    }
    const dockerTagPrefix = findDockerTagPrefix(process.env.DOCKER_IMAGE_ASSET_HASH);
    const regexp = new RegExp(`(${dockerTagPrefix})?[a-f0-9]{64}`, 'g');
    const hashes = template.TemplateBody.match(regexp);
    return [...new Set(hashes)];
}
exports.handler = handler;
function findDockerTagPrefix(hash) {
    if (hash.length === 64) {
        return '';
    }
    return hash.substring(0, hash.length - 64);
}
//# sourceMappingURL=data:application/json;base64,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