"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
const cloudFormationClient = new client_cloudformation_1.CloudFormationClient({});
async function handler() {
    const res = [];
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await cloudFormationClient.send(new client_cloudformation_1.DescribeStacksCommand({ NextToken: nextToken }));
        for (const stack of (response.Stacks ?? [])) {
            if (stack.StackName) {
                res.push(stack.StackName);
            }
        }
        nextToken = response.NextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return res;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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