"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_s3_1 = require("@aws-sdk/client-s3");
async function handler(event) {
    const request = event.Records[0].cf.request;
    try {
        const s3Origin = request.origin?.s3;
        if (!s3Origin) {
            throw new Error('No S3 origin');
        }
        const s3Client = new client_s3_1.S3Client({ region: s3Origin.region });
        const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), '');
        const key = request.uri.substring(1); // remove first slash
        const data = await s3Client.send(new client_s3_1.GetObjectCommand({
            Bucket: bucket,
            Key: key,
        }));
        if (!data.Body) {
            throw new Error('No body');
        }
        const redirect = JSON.parse(await data.Body.transformToString());
        return {
            status: '301',
            statusDescription: 'Moved Permanently',
            headers: {
                location: [{
                        key: 'Location',
                        value: redirect.url,
                    }],
            },
        };
    }
    catch (err) {
        console.log(err);
        return {
            status: '404',
            statusDescription: 'Not Found',
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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