"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const _shell_1 = require("./_shell");
const PARSE_DIGEST = /digest:\ (sha256:[0-9a-f]+)/;
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other than docker hub, you can specify the registry
 * URL through the `registry` option.
 */
class Image extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const registry = props.registry ?? 'docker.io/library';
        const name = props.name || cdk8s_1.Names.toDnsLabel(this);
        const tag = props.tag || 'latest';
        const fullTag = `${registry}/${name}:${tag}`;
        const allBuildArgs = [];
        props.buildArgs?.forEach((arg) => {
            allBuildArgs.push('--build-arg');
            allBuildArgs.push(`${arg.name}=${arg.value}`);
        });
        if (props.file) {
            allBuildArgs.push('-f');
            allBuildArgs.push(props.file);
        }
        if (props.platform) {
            allBuildArgs.push(`--platform=${props.platform}`);
        }
        console.error(`building docker image ${fullTag} from ${props.file ? props.file : props.dir}`);
        (0, _shell_1.shell)('docker', 'build', '-t', fullTag, props.dir, ...allBuildArgs);
        console.error(`pushing docker image ${fullTag} to ${registry}`);
        const push = (0, _shell_1.shell)('docker', 'push', fullTag);
        const result = PARSE_DIGEST.exec(push);
        if (!result) {
            throw new Error(`unable to read image digest after push: ${push}`);
        }
        this.url = props.tag ? fullTag : `${registry}/${name}@${result[1]}`;
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdk8s-image.Image", version: "0.2.695" };
//# sourceMappingURL=data:application/json;base64,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