/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ActiveDirectoryDomainServiceTrustConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#domain_service_id ActiveDirectoryDomainServiceTrust#domain_service_id}
    */
    readonly domainServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#id ActiveDirectoryDomainServiceTrust#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#name ActiveDirectoryDomainServiceTrust#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#password ActiveDirectoryDomainServiceTrust#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#trusted_domain_dns_ips ActiveDirectoryDomainServiceTrust#trusted_domain_dns_ips}
    */
    readonly trustedDomainDnsIps: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#trusted_domain_fqdn ActiveDirectoryDomainServiceTrust#trusted_domain_fqdn}
    */
    readonly trustedDomainFqdn: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#timeouts ActiveDirectoryDomainServiceTrust#timeouts}
    */
    readonly timeouts?: ActiveDirectoryDomainServiceTrustTimeouts;
}
export interface ActiveDirectoryDomainServiceTrustTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#create ActiveDirectoryDomainServiceTrust#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#delete ActiveDirectoryDomainServiceTrust#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#read ActiveDirectoryDomainServiceTrust#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#update ActiveDirectoryDomainServiceTrust#update}
    */
    readonly update?: string;
}
export declare function activeDirectoryDomainServiceTrustTimeoutsToTerraform(struct?: ActiveDirectoryDomainServiceTrustTimeouts | cdktf.IResolvable): any;
export declare function activeDirectoryDomainServiceTrustTimeoutsToHclTerraform(struct?: ActiveDirectoryDomainServiceTrustTimeouts | cdktf.IResolvable): any;
export declare class ActiveDirectoryDomainServiceTrustTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ActiveDirectoryDomainServiceTrustTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ActiveDirectoryDomainServiceTrustTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust azurerm_active_directory_domain_service_trust}
*/
export declare class ActiveDirectoryDomainServiceTrust extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_active_directory_domain_service_trust";
    /**
    * Generates CDKTF code for importing a ActiveDirectoryDomainServiceTrust resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ActiveDirectoryDomainServiceTrust to import
    * @param importFromId The id of the existing ActiveDirectoryDomainServiceTrust that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ActiveDirectoryDomainServiceTrust to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/active_directory_domain_service_trust azurerm_active_directory_domain_service_trust} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ActiveDirectoryDomainServiceTrustConfig
    */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainServiceTrustConfig);
    private _domainServiceId?;
    get domainServiceId(): string;
    set domainServiceId(value: string);
    get domainServiceIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _trustedDomainDnsIps?;
    get trustedDomainDnsIps(): string[];
    set trustedDomainDnsIps(value: string[]);
    get trustedDomainDnsIpsInput(): string[] | undefined;
    private _trustedDomainFqdn?;
    get trustedDomainFqdn(): string;
    set trustedDomainFqdn(value: string);
    get trustedDomainFqdnInput(): string | undefined;
    private _timeouts;
    get timeouts(): ActiveDirectoryDomainServiceTrustTimeoutsOutputReference;
    putTimeouts(value: ActiveDirectoryDomainServiceTrustTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ActiveDirectoryDomainServiceTrustTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
