/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#app_service_id AppServiceConnection#app_service_id}
    */
    readonly appServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#client_type AppServiceConnection#client_type}
    */
    readonly clientType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#id AppServiceConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#name AppServiceConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#target_resource_id AppServiceConnection#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#vnet_solution AppServiceConnection#vnet_solution}
    */
    readonly vnetSolution?: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#authentication AppServiceConnection#authentication}
    */
    readonly authentication: AppServiceConnectionAuthentication;
    /**
    * secret_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#secret_store AppServiceConnection#secret_store}
    */
    readonly secretStore?: AppServiceConnectionSecretStore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#timeouts AppServiceConnection#timeouts}
    */
    readonly timeouts?: AppServiceConnectionTimeouts;
}
export interface AppServiceConnectionAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#certificate AppServiceConnection#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#client_id AppServiceConnection#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#name AppServiceConnection#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#principal_id AppServiceConnection#principal_id}
    */
    readonly principalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#secret AppServiceConnection#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#subscription_id AppServiceConnection#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#type AppServiceConnection#type}
    */
    readonly type: string;
}
export declare function appServiceConnectionAuthenticationToTerraform(struct?: AppServiceConnectionAuthenticationOutputReference | AppServiceConnectionAuthentication): any;
export declare function appServiceConnectionAuthenticationToHclTerraform(struct?: AppServiceConnectionAuthenticationOutputReference | AppServiceConnectionAuthentication): any;
export declare class AppServiceConnectionAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceConnectionAuthentication | undefined;
    set internalValue(value: AppServiceConnectionAuthentication | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    resetPrincipalId(): void;
    get principalIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AppServiceConnectionSecretStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#key_vault_id AppServiceConnection#key_vault_id}
    */
    readonly keyVaultId: string;
}
export declare function appServiceConnectionSecretStoreToTerraform(struct?: AppServiceConnectionSecretStoreOutputReference | AppServiceConnectionSecretStore): any;
export declare function appServiceConnectionSecretStoreToHclTerraform(struct?: AppServiceConnectionSecretStoreOutputReference | AppServiceConnectionSecretStore): any;
export declare class AppServiceConnectionSecretStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceConnectionSecretStore | undefined;
    set internalValue(value: AppServiceConnectionSecretStore | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
}
export interface AppServiceConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#create AppServiceConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#delete AppServiceConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#read AppServiceConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#update AppServiceConnection#update}
    */
    readonly update?: string;
}
export declare function appServiceConnectionTimeoutsToTerraform(struct?: AppServiceConnectionTimeouts | cdktf.IResolvable): any;
export declare function appServiceConnectionTimeoutsToHclTerraform(struct?: AppServiceConnectionTimeouts | cdktf.IResolvable): any;
export declare class AppServiceConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection azurerm_app_service_connection}
*/
export declare class AppServiceConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_connection";
    /**
    * Generates CDKTF code for importing a AppServiceConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceConnection to import
    * @param importFromId The id of the existing AppServiceConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/app_service_connection azurerm_app_service_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceConnectionConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceConnectionConfig);
    private _appServiceId?;
    get appServiceId(): string;
    set appServiceId(value: string);
    get appServiceIdInput(): string | undefined;
    private _clientType?;
    get clientType(): string;
    set clientType(value: string);
    resetClientType(): void;
    get clientTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _vnetSolution?;
    get vnetSolution(): string;
    set vnetSolution(value: string);
    resetVnetSolution(): void;
    get vnetSolutionInput(): string | undefined;
    private _authentication;
    get authentication(): AppServiceConnectionAuthenticationOutputReference;
    putAuthentication(value: AppServiceConnectionAuthentication): void;
    get authenticationInput(): AppServiceConnectionAuthentication | undefined;
    private _secretStore;
    get secretStore(): AppServiceConnectionSecretStoreOutputReference;
    putSecretStore(value: AppServiceConnectionSecretStore): void;
    resetSecretStore(): void;
    get secretStoreInput(): AppServiceConnectionSecretStore | undefined;
    private _timeouts;
    get timeouts(): AppServiceConnectionTimeoutsOutputReference;
    putTimeouts(value: AppServiceConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
